/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.Properties;
import javax.validation.Validator;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.GuiceAnnotationIntrospector;
import org.apache.druid.guice.GuiceInjectableValues;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Smile;
import org.skife.config.ConfigurationObjectFactory;

public class DruidSecondaryModule
implements Module {
    private final Properties properties;
    private final ConfigurationObjectFactory factory;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final Validator validator;

    @Inject
    public DruidSecondaryModule(Properties properties, ConfigurationObjectFactory factory, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, Validator validator) {
        this.properties = properties;
        this.factory = factory;
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.validator = validator;
    }

    public void configure(Binder binder) {
        binder.install((Module)new DruidGuiceExtensions());
        binder.bind(Properties.class).toInstance((Object)this.properties);
        binder.bind(ConfigurationObjectFactory.class).toInstance((Object)this.factory);
        binder.bind(ObjectMapper.class).to(Key.get(ObjectMapper.class, Json.class));
        binder.bind(Validator.class).toInstance((Object)this.validator);
        binder.bind(JsonConfigurator.class);
    }

    @Provides
    @LazySingleton
    @Json
    public ObjectMapper getJsonMapper(Injector injector) {
        this.setupJackson(injector, this.jsonMapper);
        return this.jsonMapper;
    }

    @Provides
    @LazySingleton
    @Smile
    public ObjectMapper getSmileMapper(Injector injector) {
        this.setupJackson(injector, this.smileMapper);
        return this.smileMapper;
    }

    private void setupJackson(Injector injector, ObjectMapper mapper) {
        GuiceAnnotationIntrospector guiceIntrospector = new GuiceAnnotationIntrospector();
        mapper.setInjectableValues((InjectableValues)new GuiceInjectableValues(injector));
        mapper.setAnnotationIntrospectors((AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)guiceIntrospector, mapper.getSerializationConfig().getAnnotationIntrospector()), (AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)guiceIntrospector, mapper.getDeserializationConfig().getAnnotationIntrospector()));
    }
}

