/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.druid.java.util.common.StringUtils;

public class TaskIdUtils {
    private static final Pattern INVALIDCHARS = Pattern.compile("(?s).*[^\\S ].*");
    private static final Joiner UNDERSCORE_JOINER = Joiner.on((String)"_");

    public static void validateId(String thingToValidate, String stringToValidate) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)stringToValidate) ? 1 : 0) != 0, (Object)StringUtils.format("%s cannot be null or empty. Please provide a %s.", thingToValidate, thingToValidate));
        Preconditions.checkArgument((!stringToValidate.startsWith(".") ? 1 : 0) != 0, (Object)StringUtils.format("%s cannot start with the '.' character.", thingToValidate));
        Preconditions.checkArgument((!stringToValidate.contains("/") ? 1 : 0) != 0, (Object)StringUtils.format("%s cannot contain the '/' character.", thingToValidate));
        Matcher m = INVALIDCHARS.matcher(stringToValidate);
        Preconditions.checkArgument((!m.matches() ? 1 : 0) != 0, (Object)StringUtils.format("%s cannot contain whitespace character except space.", thingToValidate));
    }

    public static String getRandomId() {
        StringBuilder suffix = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            suffix.append((char)(97 + (ThreadLocalRandom.current().nextInt() >>> i * 4 & 0xF)));
        }
        return suffix.toString();
    }

    public static String getRandomIdWithPrefix(String prefix) {
        return UNDERSCORE_JOINER.join((Object)prefix, (Object)TaskIdUtils.getRandomId(), new Object[0]);
    }
}

