/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class TaskLocation {
    private static final TaskLocation UNKNOWN = new TaskLocation(null, -1, -1);
    private final String host;
    private final int port;
    private final int tlsPort;

    public static TaskLocation create(String host, int port, int tlsPort) {
        return new TaskLocation(host, port, tlsPort);
    }

    public static TaskLocation unknown() {
        return UNKNOWN;
    }

    @JsonCreator
    public TaskLocation(@JsonProperty(value="host") String host, @JsonProperty(value="port") int port, @JsonProperty(value="tlsPort") int tlsPort) {
        this.host = host;
        this.port = port;
        this.tlsPort = tlsPort;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public int getTlsPort() {
        return this.tlsPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskLocation that = (TaskLocation)o;
        return this.port == that.port && this.tlsPort == that.tlsPort && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + this.port;
        result = 31 * result + this.tlsPort;
        return result;
    }

    public String toString() {
        return "TaskLocation{host='" + this.host + '\'' + ", port=" + this.port + ", tlsPort=" + this.tlsPort + '}';
    }
}

