/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;

public class TaskStatus {
    public static final int MAX_ERROR_MSG_LENGTH = 100;
    private final String id;
    private final TaskState status;
    private final long duration;
    @Nullable
    private final String errorMsg;
    private final TaskLocation location;

    public static TaskStatus running(String taskId) {
        return new TaskStatus(taskId, TaskState.RUNNING, -1L, null, null);
    }

    public static TaskStatus success(String taskId) {
        return new TaskStatus(taskId, TaskState.SUCCESS, -1L, null, null);
    }

    public static TaskStatus success(String taskId, String errorMsg) {
        return new TaskStatus(taskId, TaskState.SUCCESS, -1L, errorMsg, null);
    }

    public static TaskStatus failure(String taskId) {
        return new TaskStatus(taskId, TaskState.FAILED, -1L, null, null);
    }

    public static TaskStatus failure(String taskId, String errorMsg) {
        return new TaskStatus(taskId, TaskState.FAILED, -1L, errorMsg, null);
    }

    public static TaskStatus fromCode(String taskId, TaskState code) {
        return new TaskStatus(taskId, code, -1L, null, null);
    }

    @Nullable
    private static String truncateErrorMsg(@Nullable String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 100) {
            return errorMsg.substring(0, 100) + "...";
        }
        return errorMsg;
    }

    @JsonCreator
    protected TaskStatus(@JsonProperty(value="id") String id, @JsonProperty(value="status") TaskState status, @JsonProperty(value="duration") long duration, @JsonProperty(value="errorMsg") @Nullable String errorMsg, @Nullable @JsonProperty(value="location") TaskLocation location) {
        this.id = id;
        this.status = status;
        this.duration = duration;
        this.errorMsg = TaskStatus.truncateErrorMsg(errorMsg);
        this.location = location == null ? TaskLocation.unknown() : location;
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Preconditions.checkNotNull((Object)((Object)status), (Object)"status");
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="status")
    public TaskState getStatusCode() {
        return this.status;
    }

    @JsonProperty(value="duration")
    public long getDuration() {
        return this.duration;
    }

    @Nullable
    @JsonProperty(value="errorMsg")
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @JsonProperty(value="location")
    public TaskLocation getLocation() {
        return this.location;
    }

    @JsonIgnore
    public boolean isRunnable() {
        return this.status == TaskState.RUNNING;
    }

    @JsonIgnore
    public boolean isComplete() {
        return !this.isRunnable();
    }

    @JsonIgnore
    public boolean isSuccess() {
        return this.status == TaskState.SUCCESS;
    }

    @JsonIgnore
    public boolean isFailure() {
        return this.status == TaskState.FAILED;
    }

    public TaskStatus withDuration(long _duration) {
        return new TaskStatus(this.id, this.status, _duration, this.errorMsg, this.location);
    }

    public TaskStatus withLocation(TaskLocation location) {
        if (location == null) {
            location = TaskLocation.unknown();
        }
        return new TaskStatus(this.id, this.status, this.duration, this.errorMsg, location);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("status", (Object)this.status).add("duration", this.duration).add("errorMsg", (Object)this.errorMsg).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskStatus that = (TaskStatus)o;
        return this.getDuration() == that.getDuration() && Objects.equals(this.getId(), that.getId()) && this.status == that.status && Objects.equals(this.getErrorMsg(), that.getErrorMsg());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getId(), this.status, this.getDuration(), this.getErrorMsg()});
    }
}

