/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.partitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.indexer.Checks;
import org.apache.druid.indexer.Property;
import org.apache.druid.indexer.partitions.DimensionBasedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SecondaryPartitionType;

public class SingleDimensionPartitionsSpec
implements DimensionBasedPartitionsSpec {
    public static final String NAME = "single_dim";
    static final String OLD_NAME = "dimension";
    private static final String PARITION_DIMENSION = "partitionDimension";
    private static final String MAX_PARTITION_SIZE = "maxPartitionSize";
    private static final String FORCE_GUARANTEED_ROLLUP_COMPATIBLE = "";
    private final Integer targetRowsPerSegment;
    private final Integer maxRowsPerSegment;
    private final String partitionDimension;
    private final boolean assumeGrouped;
    private final int resolvedMaxRowPerSegment;

    @JsonCreator
    public SingleDimensionPartitionsSpec(@JsonProperty(value="targetRowsPerSegment") @Nullable Integer targetRowsPerSegment, @JsonProperty(value="maxRowsPerSegment") @Nullable Integer maxRowsPerSegment, @JsonProperty(value="partitionDimension") @Nullable String partitionDimension, @JsonProperty(value="assumeGrouped") boolean assumeGrouped, @Deprecated @JsonProperty(value="targetPartitionSize") @Nullable Integer targetPartitionSize, @Deprecated @JsonProperty(value="maxPartitionSize") @Nullable Integer maxPartitionSize) {
        Integer adjustedTargetRowsPerSegment = PartitionsSpec.resolveHistoricalNullIfNeeded(targetRowsPerSegment);
        Integer adjustedMaxRowsPerSegment = PartitionsSpec.resolveHistoricalNullIfNeeded(maxRowsPerSegment);
        Integer adjustedTargetPartitionSize = PartitionsSpec.resolveHistoricalNullIfNeeded(targetPartitionSize);
        Integer adjustedMaxPartitionSize = PartitionsSpec.resolveHistoricalNullIfNeeded(maxPartitionSize);
        Property<Integer> target = Checks.checkAtMostOneNotNull("targetRowsPerSegment", adjustedTargetRowsPerSegment, "targetPartitionSize", adjustedTargetPartitionSize);
        Property<Integer> max = Checks.checkAtMostOneNotNull("maxRowsPerSegment", adjustedMaxRowsPerSegment, MAX_PARTITION_SIZE, adjustedMaxPartitionSize);
        Preconditions.checkArgument((target.getValue() == null != (max.getValue() == null) ? 1 : 0) != 0, (Object)("Exactly one of " + target.getName() + " or " + max.getName() + " must be present"));
        this.partitionDimension = partitionDimension;
        this.assumeGrouped = assumeGrouped;
        this.targetRowsPerSegment = target.getValue();
        this.maxRowsPerSegment = max.getValue();
        this.resolvedMaxRowPerSegment = SingleDimensionPartitionsSpec.resolveMaxRowsPerSegment(target, max);
    }

    @VisibleForTesting
    public SingleDimensionPartitionsSpec(@Nullable Integer targetRowsPerSegment, @Nullable Integer maxRowsPerSegment, @Nullable String partitionDimension, boolean assumeGrouped) {
        this(targetRowsPerSegment, maxRowsPerSegment, partitionDimension, assumeGrouped, null, null);
    }

    private static int resolveMaxRowsPerSegment(Property<Integer> target, Property<Integer> max) {
        int resolvedValue;
        if (target.getValue() != null) {
            Preconditions.checkArgument((target.getValue() > 0 ? 1 : 0) != 0, (Object)(target.getName() + " must be greater than 0"));
            try {
                resolvedValue = Math.addExact(target.getValue(), target.getValue() / 2);
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException(target.getName() + " is too large");
            }
        } else {
            Preconditions.checkArgument((max.getValue() > 0 ? 1 : 0) != 0, (Object)(max.getName() + " must be greater than 0"));
            resolvedValue = max.getValue();
        }
        return resolvedValue;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer getTargetRowsPerSegment() {
        return this.targetRowsPerSegment;
    }

    @Override
    public SecondaryPartitionType getType() {
        return SecondaryPartitionType.RANGE;
    }

    @Override
    @JsonIgnore
    @NotNull
    public Integer getMaxRowsPerSegment() {
        return this.resolvedMaxRowPerSegment;
    }

    @JsonProperty(value="maxRowsPerSegment")
    private Integer getMaxRowsPerSegmentForJson() {
        return this.maxRowsPerSegment;
    }

    @JsonProperty
    @Nullable
    public String getPartitionDimension() {
        return this.partitionDimension;
    }

    @JsonProperty
    public boolean isAssumeGrouped() {
        return this.assumeGrouped;
    }

    @Override
    @JsonIgnore
    public List<String> getPartitionDimensions() {
        return this.partitionDimension == null ? Collections.emptyList() : Collections.singletonList(this.partitionDimension);
    }

    @Override
    public String getForceGuaranteedRollupIncompatiblityReason() {
        if (this.getPartitionDimension() == null) {
            return "partitionDimension must be specified";
        }
        return FORCE_GUARANTEED_ROLLUP_COMPATIBLE;
    }

    @Override
    public boolean needsDeterminePartitions(boolean useForHadoopTask) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleDimensionPartitionsSpec that = (SingleDimensionPartitionsSpec)o;
        return this.assumeGrouped == that.assumeGrouped && this.resolvedMaxRowPerSegment == that.resolvedMaxRowPerSegment && Objects.equals(this.targetRowsPerSegment, that.targetRowsPerSegment) && Objects.equals(this.maxRowsPerSegment, that.maxRowsPerSegment) && Objects.equals(this.partitionDimension, that.partitionDimension);
    }

    public int hashCode() {
        return Objects.hash(this.targetRowsPerSegment, this.maxRowsPerSegment, this.partitionDimension, this.assumeGrouped, this.resolvedMaxRowPerSegment);
    }

    public String toString() {
        return "SingleDimensionPartitionsSpec{targetRowsPerSegment=" + this.targetRowsPerSegment + ", maxRowsPerSegment=" + this.maxRowsPerSegment + ", partitionDimension='" + this.partitionDimension + '\'' + ", assumeGrouped=" + this.assumeGrouped + ", resolvedMaxRowPerSegment=" + this.resolvedMaxRowPerSegment + '}';
    }
}

