/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.AbstractHttpClient;
import org.apache.druid.java.util.http.client.HttpClientConfig;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.pool.ResourceContainer;
import org.apache.druid.java.util.http.client.pool.ResourcePool;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.timeout.ReadTimeoutHandler;
import org.jboss.netty.util.Timer;
import org.joda.time.Duration;

public class NettyHttpClient
extends AbstractHttpClient {
    private static final Logger log = new Logger(NettyHttpClient.class);
    private static final String READ_TIMEOUT_HANDLER_NAME = "read-timeout";
    private static final String LAST_HANDLER_NAME = "last-handler";
    private final Timer timer;
    private final ResourcePool<String, ChannelFuture> pool;
    private final HttpClientConfig.CompressionCodec compressionCodec;
    private final Duration defaultReadTimeout;
    private long backPressureStartTimeNs;

    NettyHttpClient(ResourcePool<String, ChannelFuture> pool, Duration defaultReadTimeout, HttpClientConfig.CompressionCodec compressionCodec, Timer timer) {
        this.pool = (ResourcePool)Preconditions.checkNotNull(pool, (Object)"pool");
        this.defaultReadTimeout = defaultReadTimeout;
        this.compressionCodec = (HttpClientConfig.CompressionCodec)((Object)Preconditions.checkNotNull((Object)((Object)compressionCodec)));
        this.timer = timer;
        if (defaultReadTimeout != null && defaultReadTimeout.getMillis() > 0L) {
            Preconditions.checkNotNull((Object)timer, (Object)"timer");
        }
    }

    @LifecycleStart
    public void start() {
    }

    @LifecycleStop
    public void stop() {
        this.pool.close();
    }

    @Override
    public <Intermediate, Final> ListenableFuture<Final> go(Request request, final HttpResponseHandler<Intermediate, Final> handler, Duration requestReadTimeout) {
        String hostKey;
        ResourceContainer<ChannelFuture> channelResourceContainer;
        ChannelFuture channelFuture;
        HttpMethod method = request.getMethod();
        URL url = request.getUrl();
        Multimap<String, String> headers = request.getHeaders();
        final String requestDesc = StringUtils.format("%s %s", method, url);
        if (log.isDebugEnabled()) {
            log.debug("[%s] starting", requestDesc);
        }
        if (!(channelFuture = (channelResourceContainer = this.pool.take(hostKey = this.getPoolKey(url))).get().awaitUninterruptibly()).isSuccess()) {
            channelResourceContainer.returnResource();
            return Futures.immediateFailedFuture((Throwable)new ChannelException("Faulty channel in resource pool", channelFuture.getCause()));
        }
        final Channel channel = channelFuture.getChannel();
        channel.setReadable(true);
        String urlFile = StringUtils.nullToEmptyNonDruidDataString(url.getFile());
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, method, urlFile.isEmpty() ? "/" : urlFile);
        if (!headers.containsKey((Object)"Host")) {
            httpRequest.headers().add("Host", (Object)this.getHost(url));
        }
        if (!headers.containsKey((Object)"Accept-Encoding")) {
            httpRequest.headers().set("Accept-Encoding", (Object)this.compressionCodec.getEncodingString());
        }
        for (Map.Entry entry : headers.asMap().entrySet()) {
            String key = (String)entry.getKey();
            for (String obj : (Collection)entry.getValue()) {
                httpRequest.headers().add(key, (Object)obj);
            }
        }
        if (request.hasContent()) {
            httpRequest.setContent(request.getContent());
        }
        final long readTimeout = this.getReadTimeout(requestReadTimeout);
        final SettableFuture retVal = SettableFuture.create();
        if (readTimeout > 0L) {
            channel.getPipeline().addLast(READ_TIMEOUT_HANDLER_NAME, (ChannelHandler)new ReadTimeoutHandler(this.timer, readTimeout, TimeUnit.MILLISECONDS));
        }
        channel.getPipeline().addLast(LAST_HANDLER_NAME, (ChannelHandler)new SimpleChannelUpstreamHandler(){
            private volatile ClientResponse<Intermediate> response = null;
            private long currentChunkNum = 0L;
            private final Object watermarkLock = new Object();
            private long suspendWatermark = -1L;
            private long resumeWatermark = -1L;

            public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
                block14: {
                    if (log.isDebugEnabled()) {
                        log.debug("[%s] messageReceived: %s", requestDesc, e.getMessage());
                    }
                    try {
                        Object msg = e.getMessage();
                        if (msg instanceof HttpResponse) {
                            HttpResponse httpResponse = (HttpResponse)msg;
                            if (log.isDebugEnabled()) {
                                log.debug("[%s] Got response: %s", requestDesc, httpResponse.getStatus());
                            }
                            HttpResponseHandler.TrafficCop trafficCop = resumeChunkNum -> {
                                Object object = this.watermarkLock;
                                synchronized (object) {
                                    this.resumeWatermark = Math.max(this.resumeWatermark, resumeChunkNum);
                                    if (this.suspendWatermark >= 0L && this.resumeWatermark >= this.suspendWatermark) {
                                        this.suspendWatermark = -1L;
                                        channel.setReadable(true);
                                        long backPressureDuration = System.nanoTime() - NettyHttpClient.this.backPressureStartTimeNs;
                                        log.debug("[%s] Resumed reads from channel (chunkNum = %,d).", requestDesc, resumeChunkNum);
                                        return backPressureDuration;
                                    }
                                }
                                return 0L;
                            };
                            this.response = handler.handleResponse(httpResponse, trafficCop);
                            if (this.response.isFinished()) {
                                retVal.set(this.response.getObj());
                            }
                            assert (this.currentChunkNum == 0L);
                            this.possiblySuspendReads(this.response);
                            if (!httpResponse.isChunked()) {
                                this.finishRequest();
                            }
                            break block14;
                        }
                        if (msg instanceof HttpChunk) {
                            HttpChunk httpChunk = (HttpChunk)msg;
                            if (log.isDebugEnabled()) {
                                log.debug("[%s] Got chunk: %sB, last=%s", requestDesc, httpChunk.getContent().readableBytes(), httpChunk.isLast());
                            }
                            if (httpChunk.isLast()) {
                                this.finishRequest();
                            } else {
                                this.response = handler.handleChunk(this.response, httpChunk, ++this.currentChunkNum);
                                if (this.response.isFinished() && !retVal.isDone()) {
                                    retVal.set(this.response.getObj());
                                }
                                this.possiblySuspendReads(this.response);
                            }
                            break block14;
                        }
                        throw new ISE("Unknown message type[%s]", msg.getClass());
                    }
                    catch (Exception ex) {
                        log.warn(ex, "[%s] Exception thrown while processing message, closing channel.", requestDesc);
                        if (!retVal.isDone()) {
                            retVal.set(null);
                        }
                        channel.close();
                        channelResourceContainer.returnResource();
                        throw ex;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void possiblySuspendReads(ClientResponse<?> response) {
                if (!response.isContinueReading()) {
                    Object object = this.watermarkLock;
                    synchronized (object) {
                        this.suspendWatermark = Math.max(this.suspendWatermark, this.currentChunkNum);
                        if (this.suspendWatermark > this.resumeWatermark) {
                            channel.setReadable(false);
                            NettyHttpClient.this.backPressureStartTimeNs = System.nanoTime();
                            log.debug("[%s] Suspended reads from channel (chunkNum = %,d).", requestDesc, this.currentChunkNum);
                        }
                    }
                }
            }

            private void finishRequest() {
                ClientResponse finalResponse = handler.done(this.response);
                if (!finalResponse.isFinished() || !finalResponse.isContinueReading()) {
                    throw new ISE("[%s] Didn't get a completed ClientResponse Object from [%s] (finished = %s, continueReading = %s)", requestDesc, handler.getClass(), finalResponse.isFinished(), finalResponse.isContinueReading());
                }
                if (!retVal.isDone()) {
                    retVal.set(finalResponse.getObj());
                }
                this.removeHandlers();
                channel.setReadable(true);
                channelResourceContainer.returnResource();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void exceptionCaught(ChannelHandlerContext context, ExceptionEvent event) {
                if (log.isDebugEnabled()) {
                    Throwable cause = event.getCause();
                    if (cause == null) {
                        log.debug("[%s] Caught exception", requestDesc);
                    } else {
                        log.debug(cause, "[%s] Caught exception", requestDesc);
                    }
                }
                retVal.setException(event.getCause());
                if (this.response != null) {
                    handler.exceptionCaught(this.response, event.getCause());
                }
                try {
                    if (channel.isOpen()) {
                        channel.close();
                    }
                }
                catch (Exception e) {
                    log.warn(e, "Error while closing channel", new Object[0]);
                }
                finally {
                    channelResourceContainer.returnResource();
                }
            }

            public void channelDisconnected(ChannelHandlerContext context, ChannelStateEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug("[%s] Channel disconnected", requestDesc);
                }
                if (this.response != null) {
                    handler.exceptionCaught(this.response, (Throwable)new ChannelException("Channel disconnected"));
                }
                channel.close();
                channelResourceContainer.returnResource();
                if (!retVal.isDone()) {
                    log.warn("[%s] Channel disconnected before response complete", requestDesc);
                    retVal.setException((Throwable)new ChannelException("Channel disconnected"));
                }
            }

            private void removeHandlers() {
                if (readTimeout > 0L) {
                    channel.getPipeline().remove(NettyHttpClient.READ_TIMEOUT_HANDLER_NAME);
                }
                channel.getPipeline().remove(NettyHttpClient.LAST_HANDLER_NAME);
            }
        });
        channel.write((Object)httpRequest).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (!future.isSuccess()) {
                    channel.close();
                    channelResourceContainer.returnResource();
                    if (!retVal.isDone()) {
                        retVal.setException((Throwable)new ChannelException(StringUtils.format("[%s] Failed to write request to channel", requestDesc), future.getCause()));
                    }
                }
            }
        });
        return retVal;
    }

    private long getReadTimeout(Duration requestReadTimeout) {
        long timeout = requestReadTimeout != null ? requestReadTimeout.getMillis() : (this.defaultReadTimeout != null ? this.defaultReadTimeout.getMillis() : 0L);
        if (timeout > 0L && this.timer == null) {
            log.warn("Cannot time out requests without a timer! Disabling timeout for this request.", new Object[0]);
            return 0L;
        }
        return timeout;
    }

    private String getHost(URL url) {
        int port = url.getPort();
        if (port == -1) {
            String protocol = url.getProtocol();
            if ("http".equalsIgnoreCase(protocol)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(protocol)) {
                port = 443;
            } else {
                throw new IAE("Cannot figure out default port for protocol[%s], please set Host header.", protocol);
            }
        }
        return StringUtils.format("%s:%s", url.getHost(), port);
    }

    private String getPoolKey(URL url) {
        return StringUtils.format("%s://%s:%s", url.getProtocol(), url.getHost(), url.getPort() == -1 ? url.getDefaultPort() : url.getPort());
    }
}

