/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.StringUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.HeapChannelBufferFactory;
import org.jboss.netty.handler.codec.base64.Base64;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class Request {
    private static final ChannelBufferFactory FACTORY = HeapChannelBufferFactory.getInstance();
    private final HttpMethod method;
    private final URL url;
    private final Multimap<String, String> headers = Multimaps.newListMultimap(new HashMap(), (Supplier)new Supplier<List<String>>(){

        public List<String> get() {
            return new ArrayList<String>();
        }
    });
    private ChannelBuffer content;

    public Request(HttpMethod method, URL url) {
        this.method = method;
        this.url = url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URL getUrl() {
        return this.url;
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public ChannelBuffer getContent() {
        return this.content;
    }

    public Request copy() {
        Request retVal = new Request(this.method, this.url);
        retVal.headers.putAll(this.headers);
        retVal.content = this.content == null ? null : this.content.copy();
        return retVal;
    }

    public Request setHeader(String header, String value) {
        this.headers.replaceValues((Object)header, Collections.singletonList(value));
        return this;
    }

    public Request addHeader(String header, String value) {
        this.headers.put((Object)header, (Object)value);
        return this;
    }

    public Request addHeaderValues(String header, Iterable<String> value) {
        this.headers.putAll((Object)header, value);
        return this;
    }

    public Request addHeaderValues(Multimap<String, String> inHeaders) {
        for (Map.Entry entry : inHeaders.asMap().entrySet()) {
            this.addHeaderValues((String)entry.getKey(), (Iterable)entry.getValue());
        }
        return this;
    }

    public Request setContent(byte[] bytes) {
        return this.setContent(null, bytes);
    }

    public Request setContent(ChannelBuffer content) {
        return this.setContent(null, content);
    }

    public Request setContent(String contentType, byte[] bytes) {
        return this.setContent(contentType, bytes, 0, bytes.length);
    }

    public Request setContent(String contentType, byte[] bytes, int offset, int length) {
        return this.setContent(contentType, FACTORY.getBuffer(bytes, offset, length));
    }

    public Request setContent(String contentType, ChannelBuffer content) {
        if (contentType != null) {
            this.setHeader("Content-Type", contentType);
        }
        this.content = content;
        this.setHeader("Content-Length", String.valueOf(content.writerIndex()));
        return this;
    }

    public Request setBasicAuthentication(String username, String password) {
        String base64Value = this.base64Encode(StringUtils.format("%s:%s", username, password));
        this.setHeader("Authorization", StringUtils.format("Basic %s", base64Value));
        return this;
    }

    private String base64Encode(String value) {
        ChannelBufferFactory bufferFactory = HeapChannelBufferFactory.getInstance();
        return Base64.encode((ChannelBuffer)bufferFactory.getBuffer(ByteBuffer.wrap(value.getBytes(StandardCharsets.UTF_8))), (boolean)false).toString(StandardCharsets.UTF_8);
    }
}

