/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SubclassesMustOverrideEqualsAndHashCode;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.IdentifierExpr;

@SubclassesMustOverrideEqualsAndHashCode
public interface Expr {
    public static final String NULL_LITERAL = "null";
    public static final Joiner ARG_JOINER = Joiner.on((String)", ");

    default public boolean isLiteral() {
        return false;
    }

    @Nullable
    default public Object getLiteralValue() {
        throw new ISE("Not a literal", new Object[0]);
    }

    @Nullable
    default public IdentifierExpr getIdentifierExprIfIdentifierExpr() {
        return null;
    }

    @Nullable
    default public String getIdentifierIfIdentifier() {
        return null;
    }

    @Nullable
    default public String getBindingIfIdentifier() {
        return null;
    }

    public ExprEval eval(ObjectBinding var1);

    public String stringify();

    public void visit(Visitor var1);

    public Expr visit(Shuttle var1);

    public BindingDetails analyzeInputs();

    public static class BindingDetails {
        private final ImmutableSet<IdentifierExpr> freeVariables;
        private final ImmutableSet<IdentifierExpr> scalarVariables;
        private final ImmutableSet<IdentifierExpr> arrayVariables;
        private final boolean hasInputArrays;
        private final boolean isOutputArray;

        BindingDetails() {
            this((ImmutableSet<IdentifierExpr>)ImmutableSet.of(), (ImmutableSet<IdentifierExpr>)ImmutableSet.of(), (ImmutableSet<IdentifierExpr>)ImmutableSet.of(), false, false);
        }

        BindingDetails(IdentifierExpr expr) {
            this((ImmutableSet<IdentifierExpr>)ImmutableSet.of((Object)expr), (ImmutableSet<IdentifierExpr>)ImmutableSet.of(), (ImmutableSet<IdentifierExpr>)ImmutableSet.of(), false, false);
        }

        private BindingDetails(ImmutableSet<IdentifierExpr> freeVariables, ImmutableSet<IdentifierExpr> scalarVariables, ImmutableSet<IdentifierExpr> arrayVariables, boolean hasInputArrays, boolean isOutputArray) {
            this.freeVariables = freeVariables;
            this.scalarVariables = scalarVariables;
            this.arrayVariables = arrayVariables;
            this.hasInputArrays = hasInputArrays;
            this.isOutputArray = isOutputArray;
        }

        public List<String> getRequiredBindingsList() {
            return new ArrayList<String>(this.getRequiredBindings());
        }

        public Set<String> getRequiredBindings() {
            return BindingDetails.map(this.freeVariables, IdentifierExpr::getBindingIfIdentifier);
        }

        Set<String> getScalarBindings() {
            return BindingDetails.map(this.scalarVariables, IdentifierExpr::getBindingIfIdentifier);
        }

        public Set<String> getArrayBindings() {
            return BindingDetails.map(this.arrayVariables, IdentifierExpr::getBindingIfIdentifier);
        }

        public Set<IdentifierExpr> getFreeVariables() {
            return this.freeVariables;
        }

        Set<String> getScalarVariables() {
            return BindingDetails.map(this.scalarVariables, IdentifierExpr::getIdentifier);
        }

        Set<String> getArrayVariables() {
            return BindingDetails.map(this.arrayVariables, IdentifierExpr::getIdentifier);
        }

        public boolean hasInputArrays() {
            return this.hasInputArrays;
        }

        public boolean isOutputArray() {
            return this.isOutputArray;
        }

        public BindingDetails with(Expr other) {
            return this.with(other.analyzeInputs());
        }

        public BindingDetails with(BindingDetails other) {
            return new BindingDetails((ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.freeVariables, other.freeVariables)), (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.scalarVariables, other.scalarVariables)), (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.arrayVariables, other.arrayVariables)), this.hasInputArrays || other.hasInputArrays, this.isOutputArray || other.isOutputArray);
        }

        public BindingDetails withScalarArguments(Set<Expr> scalarArguments) {
            HashSet<IdentifierExpr> moreScalars = new HashSet<IdentifierExpr>();
            for (Expr expr : scalarArguments) {
                boolean isIdentiferExpr = expr.getIdentifierExprIfIdentifierExpr() != null;
                if (!isIdentiferExpr) continue;
                moreScalars.add((IdentifierExpr)expr);
            }
            return new BindingDetails((ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.freeVariables, moreScalars)), (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.scalarVariables, moreScalars)), this.arrayVariables, this.hasInputArrays, this.isOutputArray);
        }

        BindingDetails withArrayArguments(Set<Expr> arrayArguments) {
            HashSet<IdentifierExpr> arrayIdentifiers = new HashSet<IdentifierExpr>();
            for (Expr expr : arrayArguments) {
                boolean isIdentifierExpr = expr.getIdentifierExprIfIdentifierExpr() != null;
                if (!isIdentifierExpr) continue;
                arrayIdentifiers.add((IdentifierExpr)expr);
            }
            return new BindingDetails((ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.freeVariables, arrayIdentifiers)), this.scalarVariables, (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.arrayVariables, arrayIdentifiers)), this.hasInputArrays || !arrayArguments.isEmpty(), this.isOutputArray);
        }

        BindingDetails withArrayInputs(boolean hasArrays) {
            return new BindingDetails(this.freeVariables, this.scalarVariables, this.arrayVariables, hasArrays || !this.arrayVariables.isEmpty(), this.isOutputArray);
        }

        BindingDetails withArrayOutput(boolean isOutputArray) {
            return new BindingDetails(this.freeVariables, this.scalarVariables, this.arrayVariables, this.hasInputArrays, isOutputArray);
        }

        BindingDetails removeLambdaArguments(Set<String> lambda) {
            return new BindingDetails((ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf(this.freeVariables.stream().filter(x -> !lambda.contains(x.getIdentifier())).iterator()), (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf(this.scalarVariables.stream().filter(x -> !lambda.contains(x.getIdentifier())).iterator()), (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf(this.arrayVariables.stream().filter(x -> !lambda.contains(x.getIdentifier())).iterator()), this.hasInputArrays, this.isOutputArray);
        }

        private static Set<String> map(Set<IdentifierExpr> variables, Function<IdentifierExpr, String> mapper) {
            HashSet results = Sets.newHashSetWithExpectedSize((int)variables.size());
            for (IdentifierExpr variable : variables) {
                results.add(mapper.apply(variable));
            }
            return results;
        }
    }

    public static interface Shuttle {
        public Expr visit(Expr var1);
    }

    public static interface Visitor {
        public void visit(Expr var1);
    }

    public static interface ObjectBinding {
        @Nullable
        public Object get(String var1);
    }
}

