/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;

class LongArrayExpr
extends ConstantExpr {
    private final Long[] value;

    LongArrayExpr(Long[] value) {
        this.value = (Long[])Preconditions.checkNotNull((Object)value, (Object)"value");
    }

    @Override
    public Object getLiteralValue() {
        return this.value;
    }

    public String toString() {
        return Arrays.toString((Object[])this.value);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return ExprEval.ofLongArray(this.value);
    }

    @Override
    public String stringify() {
        if (this.value.length == 0) {
            return "<LONG>[]";
        }
        return StringUtils.format("<LONG>%s", this.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongArrayExpr that = (LongArrayExpr)o;
        return Arrays.equals((Object[])this.value, (Object[])that.value);
    }

    public int hashCode() {
        return Arrays.hashCode((Object[])this.value);
    }
}

