/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import java.io.IOException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;

public interface DataSegmentKiller {
    public static final Logger log = new Logger(DataSegmentKiller.class);

    public static String descriptorPath(String path) {
        int lastPathSeparatorIndex = path.lastIndexOf(47);
        if (lastPathSeparatorIndex == -1) {
            throw new IAE("Invalid path: [%s], should contain '/'", path);
        }
        return path.substring(0, lastPathSeparatorIndex) + "/descriptor.json";
    }

    public void kill(DataSegment var1) throws SegmentLoadingException;

    default public void killQuietly(DataSegment segment) {
        try {
            this.kill(segment);
        }
        catch (Exception e) {
            log.debug(e, "Failed to kill segment %s", segment);
        }
    }

    public void killAll() throws IOException;
}

