/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;

public class BuildingSingleDimensionShardSpec
implements BuildingShardSpec<SingleDimensionShardSpec> {
    public static final String TYPE = "building_single_dim";
    private final int bucketId;
    private final String dimension;
    @Nullable
    private final String start;
    @Nullable
    private final String end;
    private final int partitionId;

    @JsonCreator
    public BuildingSingleDimensionShardSpec(@JsonProperty(value="bucketId") int bucketId, @JsonProperty(value="dimension") String dimension, @JsonProperty(value="start") @Nullable String start, @JsonProperty(value="end") @Nullable String end, @JsonProperty(value="partitionNum") int partitionNum) {
        this.bucketId = bucketId;
        this.dimension = dimension;
        this.start = start;
        this.end = end;
        this.partitionId = partitionNum;
    }

    @JsonProperty(value="dimension")
    public String getDimension() {
        return this.dimension;
    }

    @Nullable
    @JsonProperty(value="start")
    public String getStart() {
        return this.start;
    }

    @Nullable
    @JsonProperty(value="end")
    public String getEnd() {
        return this.end;
    }

    @Override
    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return this.partitionId;
    }

    @Override
    @JsonProperty(value="bucketId")
    public int getBucketId() {
        return this.bucketId;
    }

    @Override
    public SingleDimensionShardSpec convert(int numCorePartitions) {
        return new SingleDimensionShardSpec(this.dimension, this.start, this.end, this.partitionId, numCorePartitions);
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return new NumberedPartitionChunk<T>(this.partitionId, 0, obj);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildingSingleDimensionShardSpec that = (BuildingSingleDimensionShardSpec)o;
        return this.bucketId == that.bucketId && this.partitionId == that.partitionId && Objects.equals(this.dimension, that.dimension) && Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
    }

    public int hashCode() {
        return Objects.hash(this.bucketId, this.dimension, this.start, this.end, this.partitionId);
    }

    public String toString() {
        return "BuildingSingleDimensionShardSpec{bucketId=" + this.bucketId + ", dimension='" + this.dimension + '\'' + ", start='" + this.start + '\'' + ", end='" + this.end + '\'' + ", partitionNum=" + this.partitionId + '}';
    }
}

