/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingHashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;

public class HashBucketShardSpec
implements BucketNumberedShardSpec<BuildingHashBasedNumberedShardSpec> {
    public static final String TYPE = "bucket_hash";
    private final int bucketId;
    private final int numBuckets;
    private final List<String> partitionDimensions;
    private final ObjectMapper jsonMapper;

    @JsonCreator
    public HashBucketShardSpec(@JsonProperty(value="bucketId") int bucketId, @JsonProperty(value="numBuckets") int numBuckets, @JsonProperty(value="partitionDimensions") List<String> partitionDimensions, @JacksonInject ObjectMapper jsonMapper) {
        this.bucketId = bucketId;
        this.numBuckets = numBuckets;
        this.partitionDimensions = partitionDimensions == null ? HashBasedNumberedShardSpec.DEFAULT_PARTITION_DIMENSIONS : partitionDimensions;
        this.jsonMapper = jsonMapper;
    }

    @Override
    @JsonProperty
    public int getBucketId() {
        return this.bucketId;
    }

    @JsonProperty
    public int getNumBuckets() {
        return this.numBuckets;
    }

    @JsonProperty
    public List<String> getPartitionDimensions() {
        return this.partitionDimensions;
    }

    @Override
    public BuildingHashBasedNumberedShardSpec convert(int partitionId) {
        return new BuildingHashBasedNumberedShardSpec(partitionId, this.bucketId, this.numBuckets, this.partitionDimensions, this.jsonMapper);
    }

    @Override
    public boolean isInChunk(long timestamp, InputRow inputRow) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ShardSpecLookup getLookup(List<? extends ShardSpec> shardSpecs) {
        return HashBasedNumberedShardSpec.createHashLookup(this.jsonMapper, this.partitionDimensions, shardSpecs, this.numBuckets);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashBucketShardSpec that = (HashBucketShardSpec)o;
        return this.bucketId == that.bucketId && this.numBuckets == that.numBuckets && Objects.equals(this.partitionDimensions, that.partitionDimensions);
    }

    public int hashCode() {
        return Objects.hash(this.bucketId, this.numBuckets, this.partitionDimensions);
    }

    public String toString() {
        return "HashBucket{, bucketId=" + this.bucketId + ", numBuckets=" + this.numBuckets + ", partitionDimensions=" + this.partitionDimensions + '}';
    }
}

