/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;
import org.apache.druid.timeline.partition.StringPartitionChunk;

public class SingleDimensionShardSpec
implements ShardSpec {
    public static final int UNKNOWN_NUM_CORE_PARTITIONS = -1;
    private final String dimension;
    @Nullable
    private final String start;
    @Nullable
    private final String end;
    private final int partitionNum;
    private final int numCorePartitions;

    @JsonCreator
    public SingleDimensionShardSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="start") @Nullable String start, @JsonProperty(value="end") @Nullable String end, @JsonProperty(value="partitionNum") int partitionNum, @JsonProperty(value="numCorePartitions") @Nullable Integer numCorePartitions) {
        Preconditions.checkArgument((partitionNum >= 0 ? 1 : 0) != 0, (Object)"partitionNum >= 0");
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        this.start = start;
        this.end = end;
        this.partitionNum = partitionNum;
        this.numCorePartitions = numCorePartitions == null ? -1 : numCorePartitions;
    }

    @JsonProperty(value="dimension")
    public String getDimension() {
        return this.dimension;
    }

    @Nullable
    @JsonProperty(value="start")
    public String getStart() {
        return this.start;
    }

    @Nullable
    @JsonProperty(value="end")
    public String getEnd() {
        return this.end;
    }

    @Override
    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return this.partitionNum;
    }

    @Override
    @JsonProperty
    public int getNumCorePartitions() {
        return this.numCorePartitions;
    }

    @Override
    public ShardSpecLookup getLookup(List<? extends ShardSpec> shardSpecs) {
        return SingleDimensionShardSpec.createLookup(shardSpecs);
    }

    static ShardSpecLookup createLookup(List<? extends ShardSpec> shardSpecs) {
        return (timestamp, row) -> {
            for (ShardSpec spec : shardSpecs) {
                if (!spec.isInChunk(timestamp, row)) continue;
                return spec;
            }
            throw new ISE("row[%s] doesn't fit in any shard[%s]", row, shardSpecs);
        };
    }

    @Override
    public List<String> getDomainDimensions() {
        return ImmutableList.of((Object)this.dimension);
    }

    private Range<String> getRange() {
        Range range = this.start == null && this.end == null ? Range.all() : (this.start == null ? Range.atMost((Comparable)((Object)this.end)) : (this.end == null ? Range.atLeast((Comparable)((Object)this.start)) : Range.closed((Comparable)((Object)this.start), (Comparable)((Object)this.end))));
        return range;
    }

    @Override
    public boolean possibleInDomain(Map<String, RangeSet<String>> domain) {
        RangeSet<String> rangeSet = domain.get(this.dimension);
        if (rangeSet == null) {
            return true;
        }
        return !rangeSet.subRangeSet(this.getRange()).isEmpty();
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        if (this.numCorePartitions == -1) {
            return new StringPartitionChunk<T>(this.start, this.end, this.partitionNum, obj);
        }
        return new NumberedPartitionChunk<T>(this.partitionNum, this.numCorePartitions, obj);
    }

    @Override
    public boolean isInChunk(long timestamp, InputRow inputRow) {
        return SingleDimensionShardSpec.isInChunk(this.dimension, this.start, this.end, inputRow);
    }

    private static boolean checkValue(@Nullable String start, @Nullable String end, String value) {
        if (value == null) {
            return start == null;
        }
        if (start == null) {
            return end == null || value.compareTo(end) < 0;
        }
        return value.compareTo(start) >= 0 && (end == null || value.compareTo(end) < 0);
    }

    public static boolean isInChunk(String dimension, @Nullable String start, @Nullable String end, InputRow inputRow) {
        List<String> values = inputRow.getDimension(dimension);
        if (values == null || values.size() != 1) {
            return SingleDimensionShardSpec.checkValue(start, end, null);
        }
        return SingleDimensionShardSpec.checkValue(start, end, values.get(0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleDimensionShardSpec shardSpec = (SingleDimensionShardSpec)o;
        return this.partitionNum == shardSpec.partitionNum && this.numCorePartitions == shardSpec.numCorePartitions && Objects.equals(this.dimension, shardSpec.dimension) && Objects.equals(this.start, shardSpec.start) && Objects.equals(this.end, shardSpec.end);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.start, this.end, this.partitionNum, this.numCorePartitions);
    }

    public String toString() {
        return "SingleDimensionShardSpec{dimension='" + this.dimension + '\'' + ", start='" + this.start + '\'' + ", end='" + this.end + '\'' + ", partitionNum=" + this.partitionNum + ", numCorePartitions=" + this.numCorePartitions + '}';
    }
}

