/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.BindMap;
import org.skife.jdbi.v2.sqlobject.Binder;
import org.skife.jdbi.v2.sqlobject.BinderFactory;

class BindMapFactory
implements BinderFactory {
    BindMapFactory() {
    }

    public Binder build(Annotation annotation) {
        return new Binder<BindMap, Map<String, Object>>(){

            @Override
            public void bind(SQLStatement<?> q, BindMap bind, Map<String, Object> map) {
                String prefix = "___jdbi_bare___".equals(bind.prefix()) ? "" : bind.prefix() + ".";
                HashSet<String> allowedKeys = new HashSet<String>(Arrays.asList(bind.value()));
                for (Map.Entry<String, Object> e : map.entrySet()) {
                    String keyObj = e.getKey();
                    if (!bind.implicitKeyStringConversion() && !(keyObj instanceof String)) {
                        throw new IllegalArgumentException("Key " + keyObj + " (of " + keyObj.getClass() + ") must be a String");
                    }
                    String key = keyObj.toString();
                    if (!allowedKeys.isEmpty() && !allowedKeys.remove(key)) continue;
                    q.bind(prefix + key, e.getValue());
                }
                for (String key : allowedKeys) {
                    Object val = map.get(key);
                    if (val != null) {
                        throw new IllegalStateException("Internal error: map iteration missed key " + key);
                    }
                    q.bind(prefix + key, (Object)null);
                }
            }
        };
    }
}

