/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.HashSet;
import java.util.Set;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.SqlObjectContext;
import org.skife.jdbi.v2.sqlobject.HandleDing;

class OnDemandHandleDing
implements HandleDing {
    private final IDBI dbi;
    private final ThreadLocal<LocalDing> threadDing = new ThreadLocal();
    private final ThreadLocal<SqlObjectContext> threadContext = new ThreadLocal<SqlObjectContext>(){

        @Override
        protected SqlObjectContext initialValue() {
            return new SqlObjectContext();
        }
    };

    OnDemandHandleDing(IDBI dbi) {
        this.dbi = dbi;
    }

    @Override
    public SqlObjectContext setContext(SqlObjectContext context) {
        LocalDing ding = this.threadDing.get();
        if (ding == null) {
            SqlObjectContext oldContext = this.threadContext.get();
            this.threadContext.set(context);
            return oldContext;
        }
        return ding.setContext(context);
    }

    @Override
    public Handle getHandle() {
        return this.getOrCreateLocalDing().getHandle();
    }

    @Override
    public void retain(String name) {
        this.getOrCreateLocalDing().retain(name);
    }

    private LocalDing getOrCreateLocalDing() {
        if (this.threadDing.get() == null) {
            Handle handle = this.dbi.open();
            SqlObjectContext context = this.threadContext.get();
            handle.setSqlObjectContext(context == null ? new SqlObjectContext() : context);
            this.threadContext.remove();
            this.threadDing.set(new LocalDing(handle));
        }
        return this.threadDing.get();
    }

    @Override
    public void release(String name) {
        LocalDing ding = this.threadDing.get();
        if (ding == null) {
            return;
        }
        ding.release(name);
    }

    class LocalDing
    implements HandleDing {
        private final Set<String> retentions = new HashSet<String>();
        private final Handle handle;

        LocalDing(Handle handle) {
            this.handle = handle;
        }

        @Override
        public SqlObjectContext setContext(SqlObjectContext context) {
            SqlObjectContext oldContext = this.handle.getSqlObjectContext();
            this.handle.setSqlObjectContext(context);
            return oldContext;
        }

        @Override
        public Handle getHandle() {
            return this.handle;
        }

        @Override
        public void release(String name) {
            this.retentions.remove(name);
            if (this.retentions.isEmpty()) {
                OnDemandHandleDing.this.threadDing.set(null);
                OnDemandHandleDing.this.threadContext.set(this.handle.getSqlObjectContext());
                this.handle.close();
            }
        }

        @Override
        public void retain(String name) {
            this.retentions.add(name);
        }
    }
}

