/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public enum BooleanColumnMapper implements ResultColumnMapper<Boolean>
{
    PRIMITIVE(false),
    WRAPPER(true);

    private final boolean nullable;

    private BooleanColumnMapper(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public Boolean mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        boolean value = r.getBoolean(columnNumber);
        return this.nullable && r.wasNull() ? null : Boolean.valueOf(value);
    }

    @Override
    public Boolean mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
        boolean value = r.getBoolean(columnLabel);
        return this.nullable && r.wasNull() ? null : Boolean.valueOf(value);
    }
}

