/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public enum IntegerColumnMapper implements ResultColumnMapper<Integer>
{
    PRIMITIVE(false),
    WRAPPER(true);

    private final boolean nullable;

    private IntegerColumnMapper(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public Integer mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        int value = r.getInt(columnNumber);
        return this.nullable && r.wasNull() ? null : Integer.valueOf(value);
    }

    @Override
    public Integer mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
        int value = r.getInt(columnLabel);
        return this.nullable && r.wasNull() ? null : Integer.valueOf(value);
    }
}

