/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.internal.builtin;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.OptionalLong;
import javax.annotation.concurrent.Immutable;

@Immutable
public class OptionalLongThriftCodec
implements ThriftCodec<OptionalLong> {
    @Override
    public ThriftType getType() {
        return new ThriftType(ThriftType.I64, (Type)((Object)OptionalLong.class), OptionalLong.empty());
    }

    @Override
    public OptionalLong read(TProtocolReader protocol) throws Exception {
        Objects.requireNonNull(protocol, "protocol is null");
        return OptionalLong.of(protocol.readI64());
    }

    @Override
    public void write(OptionalLong value, TProtocolWriter protocol) throws Exception {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(protocol, "protocol is null");
        protocol.writeI64(value.orElseThrow(() -> new IllegalArgumentException("value is not present")));
    }

    @Override
    public boolean isNull(OptionalLong value) {
        return value == null || !value.isPresent();
    }
}

