/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.facebook.presto.hadoop.$internal.com.google.protobuf.RpcController;
import com.facebook.presto.hadoop.$internal.com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.proto.JournalProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.JournalProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.server.protocol.FenceResponse;
import org.apache.hadoop.hdfs.server.protocol.JournalProtocol;

@InterfaceAudience.Private
public class JournalProtocolServerSideTranslatorPB
implements JournalProtocolPB {
    private final JournalProtocol impl;
    private static final JournalProtocolProtos.JournalResponseProto VOID_JOURNAL_RESPONSE = JournalProtocolProtos.JournalResponseProto.newBuilder().build();
    private static final JournalProtocolProtos.StartLogSegmentResponseProto VOID_START_LOG_SEGMENT_RESPONSE = JournalProtocolProtos.StartLogSegmentResponseProto.newBuilder().build();

    public JournalProtocolServerSideTranslatorPB(JournalProtocol impl) {
        this.impl = impl;
    }

    @Override
    public JournalProtocolProtos.JournalResponseProto journal(RpcController unused, JournalProtocolProtos.JournalRequestProto req) throws ServiceException {
        try {
            this.impl.journal(PBHelper.convert(req.getJournalInfo()), req.getEpoch(), req.getFirstTxnId(), req.getNumTxns(), req.getRecords().toByteArray());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return VOID_JOURNAL_RESPONSE;
    }

    @Override
    public JournalProtocolProtos.StartLogSegmentResponseProto startLogSegment(RpcController controller, JournalProtocolProtos.StartLogSegmentRequestProto req) throws ServiceException {
        try {
            this.impl.startLogSegment(PBHelper.convert(req.getJournalInfo()), req.getEpoch(), req.getTxid());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return VOID_START_LOG_SEGMENT_RESPONSE;
    }

    @Override
    public JournalProtocolProtos.FenceResponseProto fence(RpcController controller, JournalProtocolProtos.FenceRequestProto req) throws ServiceException {
        try {
            FenceResponse resp = this.impl.fence(PBHelper.convert(req.getJournalInfo()), req.getEpoch(), req.getFencerInfo());
            return JournalProtocolProtos.FenceResponseProto.newBuilder().setInSync(resp.isInSync()).setLastTransactionId(resp.getLastTransactionId()).setPreviousEpoch(resp.getPreviousEpoch()).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }
}

