/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.FilteredBreakIteratorBuilder;
import com.ibm.icu.text.UCharacterIterator;
import com.ibm.icu.util.BytesTrie;
import com.ibm.icu.util.CharsTrie;
import com.ibm.icu.util.CharsTrieBuilder;
import com.ibm.icu.util.StringTrieBuilder;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.text.CharacterIterator;
import java.util.HashSet;
import java.util.Iterator;

public class SimpleFilteredSentenceBreakIterator
extends BreakIterator {
    private BreakIterator delegate;
    private UCharacterIterator text;
    private CharsTrie backwardsTrie;
    private CharsTrie forwardsPartialTrie;

    public SimpleFilteredSentenceBreakIterator(BreakIterator adoptBreakIterator, CharsTrie forwardsPartialTrie, CharsTrie backwardsTrie) {
        this.delegate = adoptBreakIterator;
        this.forwardsPartialTrie = forwardsPartialTrie;
        this.backwardsTrie = backwardsTrie;
    }

    public int next() {
        int n = this.delegate.next();
        if (n == -1 || this.backwardsTrie == null) {
            return n;
        }
        this.text = UCharacterIterator.getInstance((CharacterIterator)this.delegate.getText().clone());
        do {
            this.text.setIndex(n);
            this.backwardsTrie.reset();
            int uch = this.text.previousCodePoint();
            if (uch != 32) {
                uch = this.text.nextCodePoint();
            }
            BytesTrie.Result r = BytesTrie.Result.INTERMEDIATE_VALUE;
            int bestPosn = -1;
            int bestValue = -1;
            while ((uch = this.text.previousCodePoint()) != -1 && (r = this.backwardsTrie.nextForCodePoint(uch)).hasNext()) {
                if (!r.hasValue()) continue;
                bestPosn = this.text.getIndex();
                bestValue = this.backwardsTrie.getValue();
            }
            if (r.matches()) {
                bestValue = this.backwardsTrie.getValue();
                bestPosn = this.text.getIndex();
            }
            if (bestPosn >= 0) {
                if (bestValue == 2) {
                    n = this.delegate.next();
                    if (n != -1) continue;
                    return n;
                }
                if (bestValue == 1 && this.forwardsPartialTrie != null) {
                    this.forwardsPartialTrie.reset();
                    BytesTrie.Result rfwd = BytesTrie.Result.INTERMEDIATE_VALUE;
                    this.text.setIndex(bestPosn);
                    while ((uch = this.text.nextCodePoint()) != -1 && (rfwd = this.forwardsPartialTrie.nextForCodePoint(uch)).hasNext()) {
                    }
                    if (rfwd.matches()) {
                        n = this.delegate.next();
                        if (n != -1) continue;
                        return n;
                    }
                    return n;
                }
                return n;
            }
            return n;
        } while (n != -1);
        return n;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleFilteredSentenceBreakIterator other = (SimpleFilteredSentenceBreakIterator)obj;
        return this.delegate.equals(other.delegate) && this.text.equals(other.text) && this.backwardsTrie.equals(other.backwardsTrie) && this.forwardsPartialTrie.equals(other.forwardsPartialTrie);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return -1;
    }

    public Object clone() {
        SimpleFilteredSentenceBreakIterator other = (SimpleFilteredSentenceBreakIterator)super.clone();
        return other;
    }

    public int first() {
        return this.delegate.first();
    }

    public int last() {
        return this.delegate.last();
    }

    public int next(int n) {
        throw new UnsupportedOperationException("next(int) is not yet implemented");
    }

    public int previous() {
        throw new UnsupportedOperationException("previous() is not yet implemented");
    }

    public int following(int offset) {
        throw new UnsupportedOperationException("following(int) is not yet implemented");
    }

    public int current() {
        return this.delegate.current();
    }

    public int preceding(int offset) {
        throw new UnsupportedOperationException("preceding(int) is not yet implemented");
    }

    public CharacterIterator getText() {
        return this.delegate.getText();
    }

    public void setText(CharacterIterator newText) {
        this.delegate.setText(newText);
    }

    public static class Builder
    extends FilteredBreakIteratorBuilder {
        private HashSet<String> filterSet;
        static final int PARTIAL = 1;
        static final int MATCH = 2;
        static final int SuppressInReverse = 1;
        static final int AddToForward = 2;

        public Builder(ULocale loc) {
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt55b/brkitr", loc);
            ICUResourceBundle exceptions = rb.findWithFallback("exceptions");
            ICUResourceBundle breaks = exceptions.findWithFallback("SentenceBreak");
            this.filterSet = new HashSet();
            if (breaks != null) {
                int size = breaks.getSize();
                for (int index = 0; index < size; ++index) {
                    ICUResourceBundle b = (ICUResourceBundle)breaks.get(index);
                    String br = b.getString();
                    this.filterSet.add(br);
                }
            }
        }

        public Builder() {
            this.filterSet = new HashSet();
        }

        public boolean suppressBreakAfter(String str) {
            if (this.filterSet == null) {
                this.filterSet = new HashSet();
            }
            return this.filterSet.add(str);
        }

        public boolean unsuppressBreakAfter(String str) {
            if (this.filterSet == null) {
                return false;
            }
            return this.filterSet.remove(str);
        }

        public BreakIterator build(BreakIterator adoptBreakIterator) {
            CharsTrieBuilder builder = new CharsTrieBuilder();
            CharsTrieBuilder builder2 = new CharsTrieBuilder();
            int revCount = 0;
            int fwdCount = 0;
            int subCount = this.filterSet.size();
            String[] ustrs = new String[subCount];
            int[] partials = new int[subCount];
            CharsTrie backwardsTrie = null;
            CharsTrie forwardsPartialTrie = null;
            int i = 0;
            Iterator<String> i$ = this.filterSet.iterator();
            while (i$.hasNext()) {
                String s;
                ustrs[i] = s = i$.next();
                partials[i] = 0;
                ++i;
            }
            for (i = 0; i < subCount; ++i) {
                int nn = ustrs[i].indexOf(46);
                if (nn <= -1 || nn + 1 == ustrs[i].length()) continue;
                int sameAs = -1;
                for (int j = 0; j < subCount; ++j) {
                    if (j == i || !ustrs[i].regionMatches(0, ustrs[j], 0, nn + 1)) continue;
                    if (partials[j] == 0) {
                        partials[j] = 3;
                        continue;
                    }
                    if ((partials[j] & 1) == 0) continue;
                    sameAs = j;
                }
                if (sameAs != -1 || partials[i] != 0) continue;
                StringBuilder prefix = new StringBuilder(ustrs[i].substring(0, nn + 1));
                prefix.reverse();
                builder.add(prefix, 1);
                ++revCount;
                partials[i] = 3;
            }
            for (i = 0; i < subCount; ++i) {
                if (partials[i] == 0) {
                    StringBuilder reversed = new StringBuilder(ustrs[i]).reverse();
                    builder.add(reversed, 2);
                    ++revCount;
                    continue;
                }
                builder2.add(ustrs[i], 2);
                ++fwdCount;
            }
            if (revCount > 0) {
                backwardsTrie = builder.build(StringTrieBuilder.Option.FAST);
            }
            if (fwdCount > 0) {
                forwardsPartialTrie = builder2.build(StringTrieBuilder.Option.FAST);
            }
            return new SimpleFilteredSentenceBreakIterator(adoptBreakIterator, forwardsPartialTrie, backwardsTrie);
        }
    }
}

