/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.ingestion;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.druid.DruidConfig;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.ingestion.DruidIngestionTableHandle;
import com.facebook.presto.druid.metadata.DruidColumnInfo;
import com.facebook.presto.druid.metadata.DruidColumnType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class DruidPageWriter {
    public static final JsonFactory JSON_FACTORY = new JsonFactory();
    public static final String DATA_FILE_EXTENSION = ".json.gz";
    private final Configuration hadoopConfiguration;
    private final DruidConfig druidConfig;

    @Inject
    public DruidPageWriter(DruidConfig druidConfig) {
        this.druidConfig = Objects.requireNonNull(druidConfig, "druidConfig is null");
        this.hadoopConfiguration = druidConfig.readHadoopConfiguration();
    }

    public Path append(Page page, DruidIngestionTableHandle tableHandle, Path dataPath) {
        Path dataFile = new Path(dataPath, UUID.randomUUID() + DATA_FILE_EXTENSION);
        try {
            FileSystem fileSystem = dataFile.getFileSystem(this.hadoopConfiguration);
            try (FSDataOutputStream outputStream = fileSystem.create(dataFile);
                 GZIPOutputStream zipOutputStream = new GZIPOutputStream((OutputStream)outputStream);
                 JsonGenerator jsonGen = JSON_FACTORY.createGenerator((OutputStream)zipOutputStream);){
                for (int position = 0; position < page.getPositionCount(); ++position) {
                    jsonGen.writeStartObject();
                    for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                        DruidColumnInfo column = tableHandle.getColumns().get(channel);
                        Block block = page.getBlock(channel);
                        jsonGen.writeFieldName(column.getColumnName());
                        this.writeFieldValue(jsonGen, column.getDataType(), block, position);
                    }
                    jsonGen.writeEndObject();
                }
            }
            return dataFile;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_DEEP_STORAGE_ERROR, "Ingestion failed on " + tableHandle.getTableName(), (Throwable)e);
        }
    }

    private void writeFieldValue(JsonGenerator jsonGen, DruidColumnType dataType, Block block, int position) throws IOException {
        switch (dataType) {
            case VARCHAR: 
            case OTHER: {
                jsonGen.writeString(VarcharType.VARCHAR.getSlice(block, position).toStringUtf8());
                return;
            }
            case BIGINT: 
            case TIMESTAMP: {
                jsonGen.writeNumber(BigintType.BIGINT.getLong(block, position));
                return;
            }
            case FLOAT: 
            case DOUBLE: {
                jsonGen.writeNumber(DoubleType.DOUBLE.getDouble(block, position));
                return;
            }
        }
        throw new IllegalArgumentException("unsupported type: " + (Object)((Object)dataType));
    }
}

