/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.metadata;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import java.util.Objects;

public enum DruidColumnType {
    BIGINT((Type)BigintType.BIGINT, "long"),
    DOUBLE((Type)DoubleType.DOUBLE, "double"),
    FLOAT((Type)RealType.REAL, "float"),
    OTHER((Type)VarcharType.VARCHAR, "other"),
    TIMESTAMP((Type)TimestampType.TIMESTAMP, "timestamp"),
    VARCHAR((Type)VarcharType.VARCHAR, "string");

    private final String ingestType;
    private final Type prestoType;

    private DruidColumnType(Type prestoType, String ingestType) {
        this.prestoType = Objects.requireNonNull(prestoType, "ingestType is null");
        this.ingestType = Objects.requireNonNull(ingestType, "ingestType is null");
    }

    public String getIngestType() {
        return this.ingestType;
    }

    public Type getPrestoType() {
        return this.prestoType;
    }

    public static DruidColumnType fromPrestoType(Type type) {
        if (type instanceof BigintType) {
            return BIGINT;
        }
        if (type instanceof DoubleType) {
            return DOUBLE;
        }
        if (type instanceof RealType) {
            return FLOAT;
        }
        if (type instanceof TimestampType) {
            return TIMESTAMP;
        }
        if (type instanceof VarcharType) {
            return VARCHAR;
        }
        return OTHER;
    }
}

