/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConditionalModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.decoder.DecoderModule;
import com.facebook.presto.elasticsearch.AwsSecurityConfig;
import com.facebook.presto.elasticsearch.ElasticsearchConfig;
import com.facebook.presto.elasticsearch.ElasticsearchConnector;
import com.facebook.presto.elasticsearch.ElasticsearchMetadata;
import com.facebook.presto.elasticsearch.ElasticsearchPageSourceProvider;
import com.facebook.presto.elasticsearch.ElasticsearchSplitManager;
import com.facebook.presto.elasticsearch.NodesSystemTable;
import com.facebook.presto.elasticsearch.client.ElasticsearchClient;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import java.util.Objects;
import java.util.function.Predicate;
import javax.inject.Inject;

public class ElasticsearchConnectorModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(ElasticsearchConnector.class).in(Scopes.SINGLETON);
        binder.bind(ElasticsearchMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ElasticsearchSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ElasticsearchPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(ElasticsearchClient.class).in(Scopes.SINGLETON);
        binder.bind(NodesSystemTable.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ElasticsearchConfig.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        binder.install((Module)new DecoderModule());
        OptionalBinder.newOptionalBinder((Binder)binder, AwsSecurityConfig.class);
        this.install(ConditionalModule.installModuleIf(ElasticsearchConfig.class, config -> config.getSecurity().filter(Predicate.isEqual((Object)ElasticsearchConfig.Security.AWS)).isPresent(), conditionalBinder -> ConfigBinder.configBinder((Binder)conditionalBinder).bindConfig(AwsSecurityConfig.class)));
    }

    private static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private static final long serialVersionUID = 1L;
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)value));
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown type %s", (Object)value);
            return type;
        }
    }
}

