/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.elasticsearch.BuiltinColumns;
import com.facebook.presto.elasticsearch.ElasticsearchColumnHandle;
import com.facebook.presto.elasticsearch.ElasticsearchConfig;
import com.facebook.presto.elasticsearch.ElasticsearchTableHandle;
import com.facebook.presto.elasticsearch.ElasticsearchTableLayoutHandle;
import com.facebook.presto.elasticsearch.client.ElasticsearchClient;
import com.facebook.presto.elasticsearch.client.IndexMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class ElasticsearchMetadata
implements ConnectorMetadata {
    private final ElasticsearchClient client;
    private final String schemaName;
    private final Type ipAddressType;

    @Inject
    public ElasticsearchMetadata(TypeManager typeManager, ElasticsearchClient client, ElasticsearchConfig config) {
        Objects.requireNonNull(config, "config is null");
        this.ipAddressType = typeManager.getType(new TypeSignature("ipaddress", new TypeSignatureParameter[0]));
        this.client = Objects.requireNonNull(client, "client is null");
        this.schemaName = config.getDefaultSchema();
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)this.schemaName);
    }

    public ElasticsearchTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (tableName.getSchemaName().equals(this.schemaName)) {
            String[] parts = tableName.getTableName().split(":", 2);
            String table = parts[0];
            Optional<String> query = Optional.empty();
            if (parts.length == 2) {
                query = Optional.of(parts[1]);
            }
            if (this.listTables(session, Optional.of(this.schemaName)).contains(new SchemaTableName(this.schemaName, table))) {
                return new ElasticsearchTableHandle(this.schemaName, table, query);
            }
        }
        return null;
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        ElasticsearchTableHandle handle = (ElasticsearchTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new ElasticsearchTableLayoutHandle(handle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        ElasticsearchTableHandle handle = (ElasticsearchTableHandle)table;
        return this.getTableMetadata(handle.getSchema(), handle.getIndex());
    }

    private ConnectorTableMetadata getTableMetadata(String schemaName, String tableName) {
        InternalTableMetadata internalTableMetadata = this.makeInternalTableMetadata(schemaName, tableName);
        return new ConnectorTableMetadata(new SchemaTableName(schemaName, tableName), internalTableMetadata.getColumnMetadata());
    }

    private InternalTableMetadata makeInternalTableMetadata(ConnectorTableHandle table) {
        ElasticsearchTableHandle handle = (ElasticsearchTableHandle)table;
        return this.makeInternalTableMetadata(handle.getSchema(), handle.getIndex());
    }

    private InternalTableMetadata makeInternalTableMetadata(String schema, String tableName) {
        IndexMetadata metadata = this.client.getIndexMetadata(tableName);
        List<IndexMetadata.Field> fields = this.getColumnFields(metadata);
        return new InternalTableMetadata(new SchemaTableName(schema, tableName), this.makeColumnMetadata(fields), this.makeColumnHandles(fields));
    }

    private List<IndexMetadata.Field> getColumnFields(IndexMetadata metadata) {
        ImmutableList.Builder result = ImmutableList.builder();
        Map<String, Long> counts = metadata.getSchema().getFields().stream().collect(Collectors.groupingBy(f -> f.getName().toLowerCase(Locale.ENGLISH), Collectors.counting()));
        for (IndexMetadata.Field field : metadata.getSchema().getFields()) {
            Type type = this.toPrestoType(field);
            if (type == null || counts.get(field.getName().toLowerCase(Locale.ENGLISH)) > 1L) continue;
            result.add((Object)field);
        }
        return result.build();
    }

    private List<ColumnMetadata> makeColumnMetadata(List<IndexMetadata.Field> fields) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (BuiltinColumns builtinColumn : BuiltinColumns.values()) {
            result.add((Object)builtinColumn.getMetadata());
        }
        for (IndexMetadata.Field field : fields) {
            result.add((Object)new ColumnMetadata(field.getName(), this.toPrestoType(field)));
        }
        return result.build();
    }

    private Map<String, ColumnHandle> makeColumnHandles(List<IndexMetadata.Field> fields) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (BuiltinColumns builtinColumn : BuiltinColumns.values()) {
            result.put((Object)builtinColumn.getName(), (Object)builtinColumn.getColumnHandle());
        }
        for (IndexMetadata.Field field : fields) {
            result.put((Object)field.getName(), (Object)new ElasticsearchColumnHandle(field.getName(), this.toPrestoType(field), ElasticsearchMetadata.supportsPredicates(field.getType())));
        }
        return result.build();
    }

    private static boolean supportsPredicates(IndexMetadata.Type type) {
        if (type instanceof IndexMetadata.DateTimeType) {
            return true;
        }
        if (type instanceof IndexMetadata.PrimitiveType) {
            switch (((IndexMetadata.PrimitiveType)type).getName().toLowerCase(Locale.ENGLISH)) {
                case "boolean": 
                case "byte": 
                case "short": 
                case "integer": 
                case "long": 
                case "double": 
                case "float": 
                case "keyword": {
                    return true;
                }
            }
        }
        return false;
    }

    private Type toPrestoType(IndexMetadata.Field metaDataField) {
        return this.toPrestoType(metaDataField, metaDataField.isArray());
    }

    private Type toPrestoType(IndexMetadata.Field metaDataField, boolean isArray) {
        IndexMetadata.Type type = metaDataField.getType();
        if (isArray) {
            Type elementType = this.toPrestoType(metaDataField, false);
            return new ArrayType(elementType);
        }
        if (type instanceof IndexMetadata.PrimitiveType) {
            switch (((IndexMetadata.PrimitiveType)type).getName()) {
                case "float": {
                    return RealType.REAL;
                }
                case "double": {
                    return DoubleType.DOUBLE;
                }
                case "byte": {
                    return TinyintType.TINYINT;
                }
                case "short": {
                    return SmallintType.SMALLINT;
                }
                case "integer": {
                    return IntegerType.INTEGER;
                }
                case "long": {
                    return BigintType.BIGINT;
                }
                case "string": 
                case "text": 
                case "keyword": {
                    return VarcharType.VARCHAR;
                }
                case "boolean": {
                    return BooleanType.BOOLEAN;
                }
                case "binary": {
                    return VarbinaryType.VARBINARY;
                }
                case "ip": {
                    return this.ipAddressType;
                }
            }
        } else if (type instanceof IndexMetadata.DateTimeType) {
            if (((IndexMetadata.DateTimeType)type).getFormats().isEmpty()) {
                return TimestampType.TIMESTAMP;
            }
        } else if (type instanceof IndexMetadata.ObjectType) {
            IndexMetadata.ObjectType objectType = (IndexMetadata.ObjectType)type;
            List fields = (List)objectType.getFields().stream().map(field -> RowType.field((String)field.getName(), (Type)this.toPrestoType((IndexMetadata.Field)field))).collect(ImmutableList.toImmutableList());
            return RowType.from((List)fields);
        }
        return null;
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isPresent() && !schemaName.get().equals(this.schemaName)) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        this.client.getIndexes().stream().map(index -> new SchemaTableName(this.schemaName, index)).forEach(arg_0 -> ((ImmutableList.Builder)result).add(arg_0));
        this.client.getAliases().stream().map(index -> new SchemaTableName(this.schemaName, index)).forEach(arg_0 -> ((ImmutableList.Builder)result).add(arg_0));
        return result.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        InternalTableMetadata tableMetadata = this.makeInternalTableMetadata(tableHandle);
        return tableMetadata.getColumnHandles();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        ElasticsearchColumnHandle handle = (ElasticsearchColumnHandle)columnHandle;
        return new ColumnMetadata(handle.getName(), handle.getType());
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() != null && !prefix.getSchemaName().equals(this.schemaName)) {
            return ImmutableMap.of();
        }
        if (prefix.getSchemaName() != null && prefix.getTableName() != null) {
            ConnectorTableMetadata metadata = this.getTableMetadata(prefix.getSchemaName(), prefix.getTableName());
            return ImmutableMap.of((Object)metadata.getTable(), (Object)metadata.getColumns());
        }
        return (Map)this.listTables(session, prefix.getSchemaName()).stream().map(name -> this.getTableMetadata(name.getSchemaName(), name.getTableName())).collect(ImmutableMap.toImmutableMap(ConnectorTableMetadata::getTable, ConnectorTableMetadata::getColumns));
    }

    private static class InternalTableMetadata {
        private final SchemaTableName tableName;
        private final List<ColumnMetadata> columnMetadata;
        private final Map<String, ColumnHandle> columnHandles;

        public InternalTableMetadata(SchemaTableName tableName, List<ColumnMetadata> columnMetadata, Map<String, ColumnHandle> columnHandles) {
            this.tableName = tableName;
            this.columnMetadata = columnMetadata;
            this.columnHandles = columnHandles;
        }

        public SchemaTableName getTableName() {
            return this.tableName;
        }

        public List<ColumnMetadata> getColumnMetadata() {
            return this.columnMetadata;
        }

        public Map<String, ColumnHandle> getColumnHandles() {
            return this.columnHandles;
        }
    }
}

