/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.elasticsearch.CountQueryPageSource;
import com.facebook.presto.elasticsearch.ElasticsearchColumnHandle;
import com.facebook.presto.elasticsearch.ElasticsearchSplit;
import com.facebook.presto.elasticsearch.ElasticsearchTableLayoutHandle;
import com.facebook.presto.elasticsearch.ScanQueryPageSource;
import com.facebook.presto.elasticsearch.client.ElasticsearchClient;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ElasticsearchPageSourceProvider
implements ConnectorPageSourceProvider {
    private final ElasticsearchClient client;

    @Inject
    public ElasticsearchPageSourceProvider(ElasticsearchClient client) {
        this.client = Objects.requireNonNull(client, "client is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableLayoutHandle layout, List<ColumnHandle> columns, SplitContext splitContext) {
        Objects.requireNonNull(split, "split is null");
        Objects.requireNonNull(layout, "layout is null");
        ElasticsearchTableLayoutHandle layoutHandle = (ElasticsearchTableLayoutHandle)layout;
        ElasticsearchSplit elasticsearchSplit = (ElasticsearchSplit)split;
        if (columns.isEmpty()) {
            return new CountQueryPageSource(this.client, session, layoutHandle.getTable(), elasticsearchSplit);
        }
        return new ScanQueryPageSource(this.client, session, layoutHandle.getTable(), elasticsearchSplit, (List)columns.stream().map(ElasticsearchColumnHandle.class::cast).collect(ImmutableList.toImmutableList()));
    }
}

