/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ElasticsearchSplit
implements ConnectorSplit {
    private final String index;
    private final int shard;
    private final TupleDomain<ColumnHandle> tupleDomain;
    private final Optional<String> address;

    @JsonCreator
    public ElasticsearchSplit(@JsonProperty(value="index") String index, @JsonProperty(value="shard") int shard, @JsonProperty(value="tupleDomain") TupleDomain<ColumnHandle> tupleDomain, @JsonProperty(value="address") Optional<String> address) {
        this.index = Objects.requireNonNull(index, "index is null");
        this.shard = shard;
        this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
        this.address = Objects.requireNonNull(address, "address is null");
    }

    @JsonProperty
    public String getIndex() {
        return this.index;
    }

    @JsonProperty
    public int getShard() {
        return this.shard;
    }

    @JsonProperty
    public Optional<String> getAddress() {
        return this.address;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getTupleDomain() {
        return this.tupleDomain;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.NO_PREFERENCE;
    }

    public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
        return (List)this.address.map(host -> ImmutableList.of((Object)HostAddress.fromString((String)host))).orElseGet(ImmutableList::of);
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.index).addValue(this.shard).addValue(this.tupleDomain).addValue(this.address).toString();
    }
}

