/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.spi.ConnectorTableHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public final class ElasticsearchTableHandle
implements ConnectorTableHandle {
    private final String schema;
    private final String index;
    private final Optional<String> query;

    @JsonCreator
    public ElasticsearchTableHandle(@JsonProperty(value="schema") String schema, @JsonProperty(value="index") String index, @JsonProperty(value="query") Optional<String> query) {
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.index = Objects.requireNonNull(index, "index is null");
        this.query = Objects.requireNonNull(query, "query is null");
    }

    @JsonProperty
    public String getIndex() {
        return this.index;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public Optional<String> getQuery() {
        return this.query;
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.index, this.query);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ElasticsearchTableHandle other = (ElasticsearchTableHandle)obj;
        return Objects.equals(this.getSchema(), other.getSchema()) && Objects.equals(this.getIndex(), other.getIndex()) && Objects.equals(this.getQuery(), other.getQuery());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schema", (Object)this.getSchema()).add("index", (Object)this.getIndex()).add("query", this.getQuery()).toString();
    }
}

