/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.elasticsearch.client.ElasticsearchClient;
import com.facebook.presto.elasticsearch.client.ElasticsearchNode;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class NodesSystemTable
implements SystemTable {
    private static final ConnectorTableMetadata METADATA = new ConnectorTableMetadata(new SchemaTableName("system", "nodes"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("presto_node_id", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("presto_node_address", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("elasticsearch_node_id", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("elasticsearch_node_address", (Type)VarcharType.createUnboundedVarcharType())).build());
    private final ElasticsearchClient client;
    private final Node currentNode;

    @Inject
    public NodesSystemTable(NodeManager nodeManager, ElasticsearchClient client) {
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.client = Objects.requireNonNull(client, "client is null");
        this.currentNode = nodeManager.getCurrentNode();
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.ALL_NODES;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transaction, ConnectorSession session, TupleDomain<Integer> constraint) {
        Set<ElasticsearchNode> nodes = this.client.getNodes();
        BlockBuilder nodeId = VarcharType.VARCHAR.createBlockBuilder(null, nodes.size());
        BlockBuilder prestoAddress = VarcharType.VARCHAR.createBlockBuilder(null, nodes.size());
        BlockBuilder elasticsearchNodeId = VarcharType.VARCHAR.createBlockBuilder(null, nodes.size());
        BlockBuilder elasticsearchAddress = VarcharType.VARCHAR.createBlockBuilder(null, nodes.size());
        for (ElasticsearchNode node : nodes) {
            VarcharType.VARCHAR.writeString(nodeId, this.currentNode.getNodeIdentifier());
            VarcharType.VARCHAR.writeString(prestoAddress, this.currentNode.getHostAndPort().toString());
            VarcharType.VARCHAR.writeString(elasticsearchNodeId, node.getId());
            if (node.getAddress().isPresent()) {
                VarcharType.VARCHAR.writeString(elasticsearchAddress, node.getAddress().get());
                continue;
            }
            elasticsearchAddress.appendNull();
        }
        return new FixedPageSource((Iterable)ImmutableList.of((Object)new Page(new Block[]{nodeId.build(), prestoAddress.build(), elasticsearchNodeId.build(), elasticsearchAddress.build()})));
    }
}

