/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch.decoders;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.elasticsearch.ElasticsearchErrorCode;
import com.facebook.presto.elasticsearch.decoders.Decoder;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.SearchHit;

public class TimestampDecoder
implements Decoder {
    private static final ZoneId ZULU = ZoneId.of("Z");
    private final String path;
    private final ZoneId zoneId;

    public TimestampDecoder(ConnectorSession session, String path) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.zoneId = ZoneId.of(session.getSqlFunctionProperties().getTimeZoneKey().getId());
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        DocumentField documentField = (DocumentField)hit.getFields().get(this.path);
        Object value = null;
        if (documentField != null) {
            if (documentField.getValues().size() > 1) {
                throw new PrestoException((ErrorCodeSupplier)ElasticsearchErrorCode.ELASTICSEARCH_TYPE_MISMATCH, String.format("Expected single value for column '%s', found: %s", this.path, documentField.getValues().size()));
            }
            value = documentField.getValue();
        } else {
            value = getter.get();
        }
        if (value == null) {
            output.appendNull();
        } else {
            LocalDateTime timestamp;
            if (value instanceof String) {
                timestamp = DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)((String)value), LocalDateTime::from);
            } else if (value instanceof Number) {
                timestamp = LocalDateTime.ofInstant(Instant.ofEpochMilli(((Number)value).longValue()), ZULU);
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported representation for field '%s' of type TIMESTAMP: %s [%s]", this.path, value.getClass().getSimpleName(), value));
            }
            long epochMillis = timestamp.atZone(this.zoneId).toInstant().toEpochMilli();
            TimestampType.TIMESTAMP.writeLong(output, epochMillis);
        }
    }
}

