/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.elasticsearch.ElasticsearchConnector;
import com.facebook.presto.elasticsearch.ElasticsearchConnectorModule;
import com.facebook.presto.elasticsearch.ElasticsearchHandleResolver;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import java.util.Objects;

public class ElasticsearchConnectorFactory
implements ConnectorFactory {
    ElasticsearchConnectorFactory() {
    }

    public String getName() {
        return "elasticsearch";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new ElasticsearchHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(config, "config is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new ElasticsearchConnectorModule(), binder -> {
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
            }});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (Connector)injector.getInstance(ElasticsearchConnector.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

