/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.elasticsearch.ElasticsearchSplit;
import com.facebook.presto.elasticsearch.ElasticsearchTableHandle;
import com.facebook.presto.elasticsearch.ElasticsearchTableLayoutHandle;
import com.facebook.presto.elasticsearch.client.ElasticsearchClient;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class ElasticsearchSplitManager
implements ConnectorSplitManager {
    private final ElasticsearchClient client;

    @Inject
    public ElasticsearchSplitManager(ElasticsearchClient client) {
        this.client = Objects.requireNonNull(client, "client is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        ElasticsearchTableLayoutHandle layoutHandle = (ElasticsearchTableLayoutHandle)layout;
        ElasticsearchTableHandle tableHandle = layoutHandle.getTable();
        if (tableHandle.getType().equals((Object)ElasticsearchTableHandle.Type.QUERY)) {
            return new FixedSplitSource((Iterable)ImmutableList.of((Object)new ElasticsearchSplit(tableHandle.getIndex(), 0, layoutHandle.getTupleDomain(), Optional.empty())));
        }
        List splits = (List)this.client.getSearchShards(tableHandle.getIndex()).stream().map(shard -> new ElasticsearchSplit(shard.getIndex(), shard.getId(), layoutHandle.getTupleDomain(), shard.getAddress())).collect(ImmutableList.toImmutableList());
        return new FixedSplitSource((Iterable)splits);
    }
}

