/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.elasticsearch.BuiltinColumns;
import com.facebook.presto.elasticsearch.ElasticsearchColumnHandle;
import com.facebook.presto.elasticsearch.ElasticsearchQueryBuilder;
import com.facebook.presto.elasticsearch.ElasticsearchSplit;
import com.facebook.presto.elasticsearch.ElasticsearchTableHandle;
import com.facebook.presto.elasticsearch.client.ElasticsearchClient;
import com.facebook.presto.elasticsearch.decoders.ArrayDecoder;
import com.facebook.presto.elasticsearch.decoders.BigintDecoder;
import com.facebook.presto.elasticsearch.decoders.BooleanDecoder;
import com.facebook.presto.elasticsearch.decoders.Decoder;
import com.facebook.presto.elasticsearch.decoders.DoubleDecoder;
import com.facebook.presto.elasticsearch.decoders.IdColumnDecoder;
import com.facebook.presto.elasticsearch.decoders.IntegerDecoder;
import com.facebook.presto.elasticsearch.decoders.IpAddressDecoder;
import com.facebook.presto.elasticsearch.decoders.RealDecoder;
import com.facebook.presto.elasticsearch.decoders.RowDecoder;
import com.facebook.presto.elasticsearch.decoders.ScoreColumnDecoder;
import com.facebook.presto.elasticsearch.decoders.SmallintDecoder;
import com.facebook.presto.elasticsearch.decoders.SourceColumnDecoder;
import com.facebook.presto.elasticsearch.decoders.TimestampDecoder;
import com.facebook.presto.elasticsearch.decoders.TinyintDecoder;
import com.facebook.presto.elasticsearch.decoders.VarbinaryDecoder;
import com.facebook.presto.elasticsearch.decoders.VarcharDecoder;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;

public class ScanQueryPageSource
implements ConnectorPageSource {
    private static final Logger LOG = Logger.get(ScanQueryPageSource.class);
    private final List<Decoder> decoders;
    private final SearchHitIterator iterator;
    private final BlockBuilder[] columnBuilders;
    private final List<ElasticsearchColumnHandle> columns;
    private long totalBytes;
    private long readTimeNanos;
    private long completedPositions;

    public ScanQueryPageSource(ElasticsearchClient client, ConnectorSession session, ElasticsearchTableHandle table, ElasticsearchSplit split, List<ElasticsearchColumnHandle> columns) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(columns, "columns is null");
        this.columns = ImmutableList.copyOf(columns);
        this.decoders = this.createDecoders(session, columns);
        boolean needAllFields = columns.stream().map(ElasticsearchColumnHandle::getName).anyMatch(Predicate.isEqual(BuiltinColumns.SOURCE.getName()));
        List documentFields = (List)this.flattenFields(columns).entrySet().stream().filter(entry -> ((Type)entry.getValue()).equals(TimestampType.TIMESTAMP)).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        this.columnBuilders = (BlockBuilder[])columns.stream().map(ElasticsearchColumnHandle::getType).map(type -> type.createBlockBuilder(null, 1)).toArray(BlockBuilder[]::new);
        List requiredFields = columns.stream().map(ElasticsearchColumnHandle::getName).filter(name -> !BuiltinColumns.NAMES.contains(name)).collect(Collectors.toList());
        Optional<String> sort = Optional.of("_doc");
        if (table.getQuery().isPresent()) {
            sort = Optional.empty();
        }
        long start = System.nanoTime();
        SearchResponse searchResponse = client.beginSearch(split.getIndex(), split.getShard(), ElasticsearchQueryBuilder.buildSearchQuery(session, (TupleDomain<ElasticsearchColumnHandle>)split.getTupleDomain().transform(ElasticsearchColumnHandle.class::cast), table.getQuery()), needAllFields ? Optional.empty() : Optional.of(requiredFields), documentFields, sort);
        this.readTimeNanos += System.nanoTime() - start;
        this.iterator = new SearchHitIterator(client, () -> searchResponse);
    }

    public long getCompletedBytes() {
        return this.totalBytes;
    }

    public long getCompletedPositions() {
        return this.completedPositions;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos + this.iterator.getReadTimeNanos();
    }

    public boolean isFinished() {
        return !this.iterator.hasNext();
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() {
        this.iterator.close();
    }

    public Page getNextPage() {
        long size = 0L;
        while (size < 0x100000L && this.iterator.hasNext()) {
            SearchHit hit = (SearchHit)this.iterator.next();
            Map document = hit.getSourceAsMap();
            for (int i = 0; i < this.decoders.size(); ++i) {
                String field = this.columns.get(i).getName();
                this.decoders.get(i).decode(hit, () -> ScanQueryPageSource.getField(document, field), this.columnBuilders[i]);
            }
            if (hit.getSourceRef() != null) {
                this.totalBytes += (long)hit.getSourceRef().length();
            }
            ++this.completedPositions;
            size = Arrays.stream(this.columnBuilders).mapToLong(Block::getSizeInBytes).sum();
        }
        Block[] blocks = new Block[this.columnBuilders.length];
        for (int i = 0; i < this.columnBuilders.length; ++i) {
            blocks[i] = this.columnBuilders[i].build();
            this.columnBuilders[i] = this.columnBuilders[i].newBlockBuilderLike(null);
        }
        return new Page(blocks);
    }

    public static Object getField(Map<String, Object> document, String field) {
        Object value = document.get(field);
        if (value == null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            String prefix = field + ".";
            for (Map.Entry<String, Object> entry : document.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(prefix)) continue;
                result.put(key.substring(prefix.length()), entry.getValue());
            }
            if (!result.isEmpty()) {
                return result;
            }
        }
        return value;
    }

    private Map<String, Type> flattenFields(List<ElasticsearchColumnHandle> columns) {
        HashMap<String, Type> result = new HashMap<String, Type>();
        for (ElasticsearchColumnHandle column : columns) {
            this.flattenFields(result, column.getName(), column.getType());
        }
        return result;
    }

    private void flattenFields(Map<String, Type> result, String fieldName, Type type) {
        if (type instanceof RowType) {
            for (RowType.Field field : ((RowType)type).getFields()) {
                this.flattenFields(result, ScanQueryPageSource.appendPath(fieldName, (String)field.getName().get()), field.getType());
            }
        } else {
            result.put(fieldName, type);
        }
    }

    private List<Decoder> createDecoders(ConnectorSession session, List<ElasticsearchColumnHandle> columns) {
        return (List)columns.stream().map(column -> {
            if (column.getName().equals(BuiltinColumns.ID.getName())) {
                return new IdColumnDecoder();
            }
            if (column.getName().equals(BuiltinColumns.SCORE.getName())) {
                return new ScoreColumnDecoder();
            }
            if (column.getName().equals(BuiltinColumns.SOURCE.getName())) {
                return new SourceColumnDecoder();
            }
            return this.createDecoder(session, column.getName(), column.getType());
        }).collect(ImmutableList.toImmutableList());
    }

    private Decoder createDecoder(ConnectorSession session, String path, Type type) {
        if (type.equals(VarcharType.VARCHAR)) {
            return new VarcharDecoder(path);
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return new VarbinaryDecoder(path);
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return new TimestampDecoder(session, path);
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return new BooleanDecoder(path);
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return new DoubleDecoder(path);
        }
        if (type.equals(RealType.REAL)) {
            return new RealDecoder(path);
        }
        if (type.equals(TinyintType.TINYINT)) {
            return new TinyintDecoder(path);
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return new SmallintDecoder(path);
        }
        if (type.equals(IntegerType.INTEGER)) {
            return new IntegerDecoder(path);
        }
        if (type.equals(BigintType.BIGINT)) {
            return new BigintDecoder(path);
        }
        if (type.getTypeSignature().getBase().equals("ipaddress")) {
            return new IpAddressDecoder(path, type);
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            List decoders = (List)rowType.getFields().stream().map(field -> this.createDecoder(session, ScanQueryPageSource.appendPath(path, (String)field.getName().get()), field.getType())).collect(ImmutableList.toImmutableList());
            List fieldNames = (List)rowType.getFields().stream().map(RowType.Field::getName).map(Optional::get).collect(ImmutableList.toImmutableList());
            return new RowDecoder(path, fieldNames, decoders);
        }
        if (type instanceof ArrayType) {
            Type elementType = ((ArrayType)type).getElementType();
            return new ArrayDecoder(path, this.createDecoder(session, path, elementType));
        }
        throw new UnsupportedOperationException("Type not supported: " + type);
    }

    private static String appendPath(String base, String element) {
        if (base.isEmpty()) {
            return element;
        }
        return base + "." + element;
    }

    private static class SearchHitIterator
    extends AbstractIterator<SearchHit> {
        private final ElasticsearchClient client;
        private final Supplier<SearchResponse> first;
        private SearchHits searchHits;
        private String scrollId;
        private int currentPosition;
        private long readTimeNanos;

        public SearchHitIterator(ElasticsearchClient client, Supplier<SearchResponse> first) {
            this.client = client;
            this.first = first;
        }

        public long getReadTimeNanos() {
            return this.readTimeNanos;
        }

        protected SearchHit computeNext() {
            long start;
            if (this.scrollId == null) {
                start = System.nanoTime();
                SearchResponse response = this.first.get();
                this.readTimeNanos += System.nanoTime() - start;
                this.reset(response);
            } else if (this.currentPosition == this.searchHits.getHits().length) {
                start = System.nanoTime();
                SearchResponse response = this.client.nextPage(this.scrollId);
                this.readTimeNanos += System.nanoTime() - start;
                this.reset(response);
            }
            if (this.currentPosition == this.searchHits.getHits().length) {
                return (SearchHit)this.endOfData();
            }
            SearchHit hit = this.searchHits.getAt(this.currentPosition);
            ++this.currentPosition;
            return hit;
        }

        private void reset(SearchResponse response) {
            this.scrollId = response.getScrollId();
            this.searchHits = response.getHits();
            this.currentPosition = 0;
        }

        public void close() {
            if (this.scrollId != null) {
                try {
                    this.client.clearScroll(this.scrollId);
                }
                catch (Exception e) {
                    LOG.debug("Error clearing scroll", new Object[]{e});
                }
            }
        }
    }
}

