/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch.decoders;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.elasticsearch.ElasticsearchErrorCode;
import com.facebook.presto.elasticsearch.ScanQueryPageSource;
import com.facebook.presto.elasticsearch.decoders.Decoder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.search.SearchHit;

public class RowDecoder
implements Decoder {
    private final String path;
    private final List<String> fieldNames;
    private final List<Decoder> decoders;

    public RowDecoder(String path, List<String> fieldNames, List<Decoder> decoders) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.fieldNames = fieldNames;
        this.decoders = decoders;
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        Object data = getter.get();
        if (data == null) {
            output.appendNull();
        } else if (data instanceof Map) {
            BlockBuilder row = output.beginBlockEntry();
            for (int i = 0; i < this.decoders.size(); ++i) {
                String field = this.fieldNames.get(i);
                this.decoders.get(i).decode(hit, () -> ScanQueryPageSource.getField((Map)data, field), row);
            }
            output.closeEntry();
        } else {
            throw new PrestoException((ErrorCodeSupplier)ElasticsearchErrorCode.ELASTICSEARCH_TYPE_MISMATCH, String.format("Expected object for field '%s' of type ROW: %s [%s]", this.path, data, data.getClass().getSimpleName()));
        }
    }
}

