/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.elasticsearch.ElasticsearchColumnHandle;
import com.facebook.presto.elasticsearch.ElasticsearchQueryBuilder;
import com.facebook.presto.elasticsearch.ElasticsearchSplit;
import com.facebook.presto.elasticsearch.ElasticsearchTableHandle;
import com.facebook.presto.elasticsearch.client.ElasticsearchClient;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import java.util.Objects;

public class CountQueryPageSource
implements ConnectorPageSource {
    private static final int BATCH_SIZE = 10000;
    private final long readTimeNanos;
    private long remaining;

    public CountQueryPageSource(ElasticsearchClient client, ConnectorSession session, ElasticsearchTableHandle table, ElasticsearchSplit split) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(split, "split is null");
        long start = System.nanoTime();
        long count = client.count(split.getIndex(), split.getShard(), ElasticsearchQueryBuilder.buildSearchQuery(session, (TupleDomain<ElasticsearchColumnHandle>)split.getTupleDomain().transform(ElasticsearchColumnHandle.class::cast), table.getQuery()));
        this.readTimeNanos = System.nanoTime() - start;
        this.remaining = count;
    }

    public boolean isFinished() {
        return this.remaining == 0L;
    }

    public Page getNextPage() {
        int batch = Math.toIntExact(Math.min(10000L, this.remaining));
        this.remaining -= (long)batch;
        return new Page(batch);
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getCompletedPositions() {
        return 10000L;
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() {
    }
}

