/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class ElasticsearchConfig {
    private String host;
    private int port = 9200;
    private String defaultSchema = "default";
    private int scrollSize = 1000;
    private Duration scrollTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private int maxHits = 1000;
    private Duration requestTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private Duration connectTimeout = new Duration(1.0, TimeUnit.SECONDS);
    private Duration maxRetryTime = new Duration(30.0, TimeUnit.SECONDS);
    private Duration nodeRefreshInterval = new Duration(1.0, TimeUnit.MINUTES);
    private int maxHttpConnections = 25;
    private int httpThreadCount = Runtime.getRuntime().availableProcessors();
    private boolean tlsEnabled;
    private File keystorePath;
    private File trustStorePath;
    private String keystorePassword;
    private String truststorePassword;
    private boolean ignorePublishAddress;
    private boolean verifyHostnames = true;
    private Security security;

    @NotNull
    public String getHost() {
        return this.host;
    }

    @Config(value="elasticsearch.host")
    public ElasticsearchConfig setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    @Config(value="elasticsearch.port")
    public ElasticsearchConfig setPort(int port) {
        this.port = port;
        return this;
    }

    @NotNull
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Config(value="elasticsearch.default-schema-name")
    @ConfigDescription(value="Default schema name to use")
    public ElasticsearchConfig setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        return this;
    }

    @NotNull
    @Min(value=1L)
    public @NotNull @Min(value=1L) int getScrollSize() {
        return this.scrollSize;
    }

    @Config(value="elasticsearch.scroll-size")
    @ConfigDescription(value="Scroll batch size")
    public ElasticsearchConfig setScrollSize(int scrollSize) {
        this.scrollSize = scrollSize;
        return this;
    }

    @NotNull
    public Duration getScrollTimeout() {
        return this.scrollTimeout;
    }

    @Config(value="elasticsearch.scroll-timeout")
    @ConfigDescription(value="Scroll timeout")
    public ElasticsearchConfig setScrollTimeout(Duration scrollTimeout) {
        this.scrollTimeout = scrollTimeout;
        return this;
    }

    @NotNull
    @Min(value=1L)
    public @NotNull @Min(value=1L) int getMaxHits() {
        return this.maxHits;
    }

    @Config(value="elasticsearch.max-hits")
    @ConfigDescription(value="Max number of hits a single Elasticsearch request can fetch")
    public ElasticsearchConfig setMaxHits(int maxHits) {
        this.maxHits = maxHits;
        return this;
    }

    @NotNull
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Config(value="elasticsearch.request-timeout")
    @ConfigDescription(value="Elasticsearch request timeout")
    public ElasticsearchConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @NotNull
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Config(value="elasticsearch.connect-timeout")
    @ConfigDescription(value="Elasticsearch connect timeout")
    public ElasticsearchConfig setConnectTimeout(Duration timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    @NotNull
    public Duration getMaxRetryTime() {
        return this.maxRetryTime;
    }

    @Config(value="elasticsearch.max-retry-time")
    @ConfigDescription(value="Maximum timeout in case of multiple retries")
    public ElasticsearchConfig setMaxRetryTime(Duration maxRetryTime) {
        this.maxRetryTime = maxRetryTime;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getNodeRefreshInterval() {
        return this.nodeRefreshInterval;
    }

    @Config(value="elasticsearch.node-refresh-interval")
    @ConfigDescription(value="How often to refresh the list of available Elasticsearch nodes")
    public ElasticsearchConfig setNodeRefreshInterval(Duration nodeRefreshInterval) {
        this.nodeRefreshInterval = nodeRefreshInterval;
        return this;
    }

    @Config(value="elasticsearch.max-http-connections")
    @ConfigDescription(value="Maximum number of persistent HTTP connections to Elasticsearch")
    public ElasticsearchConfig setMaxHttpConnections(int maxHttpConnections) {
        this.maxHttpConnections = maxHttpConnections;
        return this;
    }

    @NotNull
    public int getMaxHttpConnections() {
        return this.maxHttpConnections;
    }

    @Config(value="elasticsearch.http-thread-count")
    @ConfigDescription(value="Number of threads handling HTTP connections to Elasticsearch")
    public ElasticsearchConfig setHttpThreadCount(int httpThreadCount) {
        this.httpThreadCount = httpThreadCount;
        return this;
    }

    @NotNull
    public int getHttpThreadCount() {
        return this.httpThreadCount;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    @Config(value="elasticsearch.tls.enabled")
    public ElasticsearchConfig setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
        return this;
    }

    public Optional<File> getKeystorePath() {
        return Optional.ofNullable(this.keystorePath);
    }

    @Config(value="elasticsearch.tls.keystore-path")
    public ElasticsearchConfig setKeystorePath(File path) {
        this.keystorePath = path;
        return this;
    }

    public Optional<String> getKeystorePassword() {
        return Optional.ofNullable(this.keystorePassword);
    }

    @Config(value="elasticsearch.tls.keystore-password")
    @ConfigSecuritySensitive
    public ElasticsearchConfig setKeystorePassword(String password) {
        this.keystorePassword = password;
        return this;
    }

    public Optional<File> getTrustStorePath() {
        return Optional.ofNullable(this.trustStorePath);
    }

    @Config(value="elasticsearch.tls.truststore-path")
    public ElasticsearchConfig setTrustStorePath(File path) {
        this.trustStorePath = path;
        return this;
    }

    public Optional<String> getTruststorePassword() {
        return Optional.ofNullable(this.truststorePassword);
    }

    @Config(value="elasticsearch.tls.truststore-password")
    @ConfigSecuritySensitive
    public ElasticsearchConfig setTruststorePassword(String password) {
        this.truststorePassword = password;
        return this;
    }

    public boolean isVerifyHostnames() {
        return this.verifyHostnames;
    }

    @Config(value="elasticsearch.tls.verify-hostnames")
    public ElasticsearchConfig setVerifyHostnames(boolean verify) {
        this.verifyHostnames = verify;
        return this;
    }

    public boolean isIgnorePublishAddress() {
        return this.ignorePublishAddress;
    }

    @Config(value="elasticsearch.ignore-publish-address")
    public ElasticsearchConfig setIgnorePublishAddress(boolean ignorePublishAddress) {
        this.ignorePublishAddress = ignorePublishAddress;
        return this;
    }

    @NotNull
    public Optional<Security> getSecurity() {
        return Optional.ofNullable(this.security);
    }

    @Config(value="elasticsearch.security")
    public ElasticsearchConfig setSecurity(Security security) {
        this.security = security;
        return this;
    }

    public static enum Security {
        AWS,
        PASSWORD;

    }
}

