/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch.decoders;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.elasticsearch.ElasticsearchErrorCode;
import com.facebook.presto.elasticsearch.decoders.Decoder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.search.SearchHit;

public class BooleanDecoder
implements Decoder {
    private final String path;

    public BooleanDecoder(String path) {
        this.path = Objects.requireNonNull(path, "path is null");
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        Object value = getter.get();
        if (value == null) {
            output.appendNull();
        } else if (value instanceof Boolean) {
            BooleanType.BOOLEAN.writeBoolean(output, ((Boolean)value).booleanValue());
        } else {
            throw new PrestoException((ErrorCodeSupplier)ElasticsearchErrorCode.ELASTICSEARCH_TYPE_MISMATCH, String.format("Expected a boolean value for field %s of type BOOLEAN: %s [%s]", this.path, value, value.getClass().getSimpleName()));
        }
    }
}

