/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch.decoders;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.elasticsearch.ElasticsearchErrorCode;
import com.facebook.presto.elasticsearch.decoders.Decoder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import io.airlift.slice.Slices;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.search.SearchHit;

public class VarbinaryDecoder
implements Decoder {
    private final String path;

    public VarbinaryDecoder(String path) {
        this.path = Objects.requireNonNull(path, "path is null");
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        Object value = getter.get();
        if (value == null) {
            output.appendNull();
        } else if (value instanceof String) {
            VarbinaryType.VARBINARY.writeSlice(output, Slices.wrappedBuffer((byte[])Base64.getDecoder().decode(value.toString())));
        } else {
            throw new PrestoException((ErrorCodeSupplier)ElasticsearchErrorCode.ELASTICSEARCH_TYPE_MISMATCH, String.format("Expected a string value for field '%s' of type VARBINARY: %s [%s]", this.path, value, value.getClass().getSimpleName()));
        }
    }
}

