/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.bootstrap.LifeCycleMethods;
import io.airlift.bootstrap.LifeCycleMethodsMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class LifeCycleModule
implements Module {
    private final List<Object> injectedInstances = new ArrayList<Object>();
    private final LifeCycleMethodsMap lifeCycleMethodsMap = new LifeCycleMethodsMap();
    private final AtomicReference<LifeCycleManager> lifeCycleManager = new AtomicReference<Object>(null);

    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.bindListener(Matchers.any(), new TypeListener(){

            public <T> void hear(TypeLiteral<T> type, TypeEncounter<T> encounter) {
                encounter.register(obj -> {
                    if (LifeCycleModule.this.isLifeCycleClass(obj.getClass())) {
                        LifeCycleManager manager = (LifeCycleManager)LifeCycleModule.this.lifeCycleManager.get();
                        if (manager != null) {
                            try {
                                manager.addInstance(obj);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        } else {
                            LifeCycleModule.this.injectedInstances.add(obj);
                        }
                    }
                });
            }
        });
    }

    @Provides
    @Singleton
    public LifeCycleManager getServerManager() throws Exception {
        LifeCycleManager lifeCycleManager = new LifeCycleManager(this.injectedInstances, this.lifeCycleMethodsMap);
        this.lifeCycleManager.set(lifeCycleManager);
        return lifeCycleManager;
    }

    private boolean isLifeCycleClass(Class<?> clazz) {
        LifeCycleMethods methods = this.lifeCycleMethodsMap.get(clazz);
        return methods.hasFor(PostConstruct.class) || methods.hasFor(PreDestroy.class);
    }
}

