/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.expressions;

import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.ExistsExpression;
import com.facebook.presto.spi.relation.InSubqueryExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.QuantifiedComparisonExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.UnresolvedSymbolExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class RowExpressionTreeRewriter<C> {
    private final RowExpressionRewriter<C> rewriter;
    private final RowExpressionVisitor<RowExpression, Context<C>> visitor;

    public static <C, T extends RowExpression> T rewriteWith(RowExpressionRewriter<C> rewriter, T node) {
        return new RowExpressionTreeRewriter<Object>(rewriter).rewrite(node, null);
    }

    public static <C, T extends RowExpression> T rewriteWith(RowExpressionRewriter<C> rewriter, T node, C context) {
        return new RowExpressionTreeRewriter<C>(rewriter).rewrite(node, context);
    }

    public RowExpressionTreeRewriter(RowExpressionRewriter<C> rewriter) {
        this.rewriter = rewriter;
        this.visitor = new RewritingVisitor();
    }

    private List<RowExpression> rewrite(List<RowExpression> items, Context<C> context) {
        ArrayList<RowExpression> rewrittenExpressions = new ArrayList<RowExpression>();
        for (RowExpression expression : items) {
            rewrittenExpressions.add(this.rewrite(expression, context.get()));
        }
        return Collections.unmodifiableList(rewrittenExpressions);
    }

    public <T extends RowExpression> T rewrite(T node, C context) {
        return (T)((RowExpression)node.accept(this.visitor, new Context(context, false)));
    }

    public <T extends RowExpression> T defaultRewrite(T node, C context) {
        return (T)((RowExpression)node.accept(this.visitor, new Context(context, true)));
    }

    private static <T> boolean sameElements(Collection<? extends T> a, Collection<? extends T> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<T> first = a.iterator();
        Iterator<T> second = b.iterator();
        while (first.hasNext() && second.hasNext()) {
            if (first.next() == second.next()) continue;
            return false;
        }
        return true;
    }

    public static class Context<C> {
        private final boolean defaultRewrite;
        private final C context;

        private Context(C context, boolean defaultRewrite) {
            this.context = context;
            this.defaultRewrite = defaultRewrite;
        }

        public C get() {
            return this.context;
        }

        public boolean isDefaultRewrite() {
            return this.defaultRewrite;
        }
    }

    private class RewritingVisitor
    implements RowExpressionVisitor<RowExpression, Context<C>> {
        private RewritingVisitor() {
        }

        public RowExpression visitInputReference(InputReferenceExpression input, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteInputReference(input, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return input;
        }

        public RowExpression visitCall(CallExpression call, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteCall(call, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List arguments = RowExpressionTreeRewriter.this.rewrite((RowExpression)call.getArguments(), (Object)context);
            if (!RowExpressionTreeRewriter.sameElements(call.getArguments(), arguments)) {
                return new CallExpression(call.getSourceLocation(), call.getDisplayName(), call.getFunctionHandle(), call.getType(), arguments);
            }
            return call;
        }

        public RowExpression visitConstant(ConstantExpression literal, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteConstant(literal, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return literal;
        }

        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteLambda(lambda, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            RowExpression body = RowExpressionTreeRewriter.this.rewrite(lambda.getBody(), context.get());
            if (body != lambda.getBody()) {
                return new LambdaDefinitionExpression(lambda.getSourceLocation(), lambda.getArgumentTypes(), lambda.getArguments(), body);
            }
            return lambda;
        }

        public RowExpression visitVariableReference(VariableReferenceExpression variable, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteVariableReference(variable, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return variable;
        }

        public RowExpression visitSpecialForm(SpecialFormExpression specialForm, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteSpecialForm(specialForm, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List arguments = RowExpressionTreeRewriter.this.rewrite((RowExpression)specialForm.getArguments(), (Object)context);
            if (!RowExpressionTreeRewriter.sameElements(specialForm.getArguments(), arguments)) {
                return new SpecialFormExpression(specialForm.getForm(), specialForm.getType(), arguments);
            }
            return specialForm;
        }

        public RowExpression visitInSubqueryExpression(InSubqueryExpression inSubqueryExpression, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteRowExpression((RowExpression)inSubqueryExpression, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            VariableReferenceExpression value = RowExpressionTreeRewriter.this.rewrite(inSubqueryExpression.getValue(), context.get());
            VariableReferenceExpression subquery = RowExpressionTreeRewriter.this.rewrite(inSubqueryExpression.getSubquery(), context.get());
            if (inSubqueryExpression.getValue() != value || inSubqueryExpression.getSubquery() != subquery) {
                return new InSubqueryExpression(inSubqueryExpression.getSourceLocation(), value, subquery);
            }
            return inSubqueryExpression;
        }

        public RowExpression visitQuantifiedComparisonExpression(QuantifiedComparisonExpression quantifiedComparisonExpression, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteRowExpression((RowExpression)quantifiedComparisonExpression, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            RowExpression value = RowExpressionTreeRewriter.this.rewrite(quantifiedComparisonExpression.getValue(), context.get());
            RowExpression subquery = RowExpressionTreeRewriter.this.rewrite(quantifiedComparisonExpression.getSubquery(), context.get());
            if (quantifiedComparisonExpression.getValue() != value || quantifiedComparisonExpression.getSubquery() != subquery) {
                return new QuantifiedComparisonExpression(quantifiedComparisonExpression.getSourceLocation(), quantifiedComparisonExpression.getOperator(), quantifiedComparisonExpression.getQuantifier(), value, subquery);
            }
            return quantifiedComparisonExpression;
        }

        public RowExpression visitExistsExpression(ExistsExpression existsExpression, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteRowExpression((RowExpression)existsExpression, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            RowExpression subquery = RowExpressionTreeRewriter.this.rewrite(existsExpression.getSubquery(), context.get());
            if (existsExpression.getSubquery() != subquery) {
                return new ExistsExpression(existsExpression.getSourceLocation(), subquery);
            }
            return existsExpression;
        }

        public RowExpression visitUnresolvedSymbolExpression(UnresolvedSymbolExpression unresolvedSymbolExpression, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteRowExpression((RowExpression)unresolvedSymbolExpression, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return unresolvedSymbolExpression;
        }
    }
}

