/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.expressions;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.expressions.RowExpressionTreeRewriter;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public final class DynamicFilters {
    private DynamicFilters() {
    }

    public static DynamicFilterExtractResult extractDynamicFilters(RowExpression expression) {
        List<RowExpression> conjuncts = LogicalRowExpressions.extractConjuncts(expression);
        ImmutableList.Builder staticConjuncts = ImmutableList.builder();
        ImmutableList.Builder dynamicConjuncts = ImmutableList.builder();
        for (RowExpression conjunct : conjuncts) {
            Optional<DynamicFilterPlaceholder> placeholder = DynamicFilters.getPlaceholder(conjunct);
            if (placeholder.isPresent()) {
                dynamicConjuncts.add((Object)placeholder.get());
                continue;
            }
            staticConjuncts.add((Object)conjunct);
        }
        return new DynamicFilterExtractResult((List<RowExpression>)staticConjuncts.build(), (List<DynamicFilterPlaceholder>)dynamicConjuncts.build());
    }

    public static boolean isDynamicFilter(RowExpression expression) {
        return DynamicFilters.getPlaceholder(expression).isPresent();
    }

    public static Optional<DynamicFilterPlaceholder> getPlaceholder(RowExpression expression) {
        if (!(expression instanceof CallExpression)) {
            return Optional.empty();
        }
        CallExpression call = (CallExpression)expression;
        List arguments = call.getArguments();
        if (!call.getDisplayName().equals("$internal$dynamic_filter_function")) {
            return Optional.empty();
        }
        Preconditions.checkArgument((arguments.size() == 3 ? 1 : 0) != 0, (String)"invalid arguments count: %s", (int)arguments.size());
        RowExpression probeSymbol = (RowExpression)arguments.get(0);
        RowExpression operatorExpression = (RowExpression)arguments.get(1);
        Preconditions.checkArgument((boolean)(operatorExpression instanceof ConstantExpression));
        Preconditions.checkArgument((boolean)(operatorExpression.getType() instanceof VarcharType));
        String operator = ((Slice)((ConstantExpression)operatorExpression).getValue()).toStringUtf8();
        RowExpression idExpression = (RowExpression)arguments.get(2);
        Preconditions.checkArgument((boolean)(idExpression instanceof ConstantExpression));
        Preconditions.checkArgument((boolean)(idExpression.getType() instanceof VarcharType));
        String id = ((Slice)((ConstantExpression)idExpression).getValue()).toStringUtf8();
        OperatorType operatorType = OperatorType.valueOf((String)operator);
        if (operatorType.isComparisonOperator()) {
            return Optional.of(new DynamicFilterPlaceholder(id, probeSymbol, operatorType));
        }
        return Optional.empty();
    }

    public static RowExpression removeNestedDynamicFilters(RowExpression expression) {
        return RowExpressionTreeRewriter.rewriteWith(new RowExpressionRewriter<AtomicBoolean>(){

            @Override
            public RowExpression rewriteRowExpression(RowExpression node, AtomicBoolean context, RowExpressionTreeRewriter<AtomicBoolean> treeRewriter) {
                return node;
            }

            @Override
            public RowExpression rewriteSpecialForm(SpecialFormExpression node, AtomicBoolean modified, RowExpressionTreeRewriter<AtomicBoolean> treeRewriter) {
                if (!this.isConjunctiveDisjunctive(node.getForm())) {
                    return node;
                }
                Preconditions.checkState((boolean)BooleanType.BOOLEAN.equals((Object)node.getType()), (Object)"AND/OR must be boolean function");
                ImmutableList.Builder expressionBuilder = ImmutableList.builder();
                for (RowExpression argument : node.getArguments()) {
                    expressionBuilder.add((Object)RowExpressionTreeRewriter.rewriteWith(this, argument, modified));
                }
                ImmutableList arguments = expressionBuilder.build();
                expressionBuilder = ImmutableList.builder();
                if (DynamicFilters.isDynamicFilter((RowExpression)arguments.get(0))) {
                    expressionBuilder.add((Object)LogicalRowExpressions.TRUE_CONSTANT);
                    modified.set(true);
                } else {
                    expressionBuilder.add((Object)((RowExpression)arguments.get(0)));
                }
                if (DynamicFilters.isDynamicFilter((RowExpression)arguments.get(1))) {
                    expressionBuilder.add((Object)LogicalRowExpressions.TRUE_CONSTANT);
                    modified.set(true);
                } else {
                    expressionBuilder.add((Object)((RowExpression)arguments.get(1)));
                }
                if (!modified.get()) {
                    return node;
                }
                arguments = expressionBuilder.build();
                if (node.getForm().equals((Object)SpecialFormExpression.Form.AND)) {
                    if (((RowExpression)arguments.get(0)).equals((Object)LogicalRowExpressions.TRUE_CONSTANT) && ((RowExpression)arguments.get(1)).equals((Object)LogicalRowExpressions.TRUE_CONSTANT)) {
                        return LogicalRowExpressions.TRUE_CONSTANT;
                    }
                    if (((RowExpression)arguments.get(0)).equals((Object)LogicalRowExpressions.TRUE_CONSTANT)) {
                        return (RowExpression)arguments.get(1);
                    }
                    if (((RowExpression)arguments.get(1)).equals((Object)LogicalRowExpressions.TRUE_CONSTANT)) {
                        return (RowExpression)arguments.get(0);
                    }
                }
                if (node.getForm().equals((Object)SpecialFormExpression.Form.OR) && (((RowExpression)arguments.get(0)).equals((Object)LogicalRowExpressions.TRUE_CONSTANT) || ((RowExpression)arguments.get(1)).equals((Object)LogicalRowExpressions.TRUE_CONSTANT))) {
                    return LogicalRowExpressions.TRUE_CONSTANT;
                }
                return new SpecialFormExpression(node.getForm(), node.getType(), (List)arguments);
            }

            private boolean isConjunctiveDisjunctive(SpecialFormExpression.Form form) {
                return form == SpecialFormExpression.Form.AND || form == SpecialFormExpression.Form.OR;
            }
        }, expression, new AtomicBoolean(false));
    }

    public static final class DynamicFilterPlaceholder {
        private final String id;
        private final RowExpression input;
        private final OperatorType operator;

        public DynamicFilterPlaceholder(String id, RowExpression input, OperatorType operator) {
            this.id = Objects.requireNonNull(id, "id is null");
            this.input = Objects.requireNonNull(input, "input is null");
            this.operator = Objects.requireNonNull(operator, "operator is null");
        }

        public DynamicFilterPlaceholder(String id, RowExpression input) {
            this(id, input, OperatorType.EQUAL);
        }

        public String getId() {
            return this.id;
        }

        public RowExpression getInput() {
            return this.input;
        }

        public OperatorType getOperator() {
            return this.operator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicFilterPlaceholder that = (DynamicFilterPlaceholder)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.input, that.input) && Objects.equals(this.operator, that.operator);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.input, this.operator);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("input", (Object)this.input).add("operator", (Object)this.operator).toString();
        }

        public Domain applyComparison(Domain domain) {
            if (domain.isNone() || domain.isAll()) {
                return domain;
            }
            Range span = domain.getValues().getRanges().getSpan();
            switch (this.operator) {
                case EQUAL: {
                    return domain;
                }
                case LESS_THAN: {
                    Range range = Range.lessThan((Type)span.getType(), (Object)span.getHigh().getValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
                case LESS_THAN_OR_EQUAL: {
                    Range range = Range.lessThanOrEqual((Type)span.getType(), (Object)span.getHigh().getValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
                case GREATER_THAN: {
                    Range range = Range.greaterThan((Type)span.getType(), (Object)span.getLow().getValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
                case GREATER_THAN_OR_EQUAL: {
                    Range range = Range.greaterThanOrEqual((Type)span.getType(), (Object)span.getLow().getValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
            }
            throw new IllegalArgumentException("Unsupported dynamic filtering comparison operator: " + this.operator);
        }
    }

    public static class DynamicFilterExtractResult {
        private final List<RowExpression> staticConjuncts;
        private final List<DynamicFilterPlaceholder> dynamicConjuncts;

        public DynamicFilterExtractResult(List<RowExpression> staticConjuncts, List<DynamicFilterPlaceholder> dynamicConjuncts) {
            this.staticConjuncts = ImmutableList.copyOf((Collection)Objects.requireNonNull(staticConjuncts, "staticConjuncts is null"));
            this.dynamicConjuncts = ImmutableList.copyOf((Collection)Objects.requireNonNull(dynamicConjuncts, "dynamicConjuncts is null"));
        }

        public List<RowExpression> getStaticConjuncts() {
            return this.staticConjuncts;
        }

        public List<DynamicFilterPlaceholder> getDynamicConjuncts() {
            return this.dynamicConjuncts;
        }
    }

    @ScalarFunction(value="$internal$dynamic_filter_function", visibility=SqlFunctionVisibility.HIDDEN)
    public static final class DynamicFilterPlaceholderFunction {
        public static final String NAME = "$internal$dynamic_filter_function";

        private DynamicFilterPlaceholderFunction() {
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") Block input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") Slice input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") long input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") boolean input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") double input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id) {
            throw new UnsupportedOperationException();
        }
    }
}

