/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.rest;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UserDefinedType;
import com.facebook.presto.functionNamespace.AbstractSqlInvokedFunctionNamespaceManager;
import com.facebook.presto.functionNamespace.InvalidFunctionHandleException;
import com.facebook.presto.functionNamespace.JsonBasedUdfFunctionMetadata;
import com.facebook.presto.functionNamespace.ServingCatalog;
import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.UdfFunctionSignatureMap;
import com.facebook.presto.functionNamespace.execution.SqlFunctionExecutors;
import com.facebook.presto.functionNamespace.rest.RestBasedFunctionApis;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AggregationFunctionImplementation;
import com.facebook.presto.spi.function.AlterRoutineCharacteristics;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionVersion;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RestFunctionHandle;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;

public class RestBasedFunctionNamespaceManager
extends AbstractSqlInvokedFunctionNamespaceManager {
    private static final Logger log = Logger.get(RestBasedFunctionNamespaceManager.class);
    private final RestBasedFunctionApis restApis;
    private final List<SqlInvokedFunction> latestFunctions = new ArrayList<SqlInvokedFunction>();
    private final AtomicReference<Optional<String>> cachedETag = new AtomicReference(Optional.empty());

    @Inject
    public RestBasedFunctionNamespaceManager(@ServingCatalog String catalogName, SqlFunctionExecutors sqlFunctionExecutors, SqlInvokedFunctionNamespaceManagerConfig config, RestBasedFunctionApis restApis) {
        super(catalogName, sqlFunctionExecutors, config);
        this.restApis = Objects.requireNonNull(restApis, "restApis is null");
    }

    public final AggregationFunctionImplementation getAggregateFunctionImplementation(FunctionHandle functionHandle, TypeManager typeManager) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Aggregate Function is not supported in RestBasedFunctionNamespaceManager");
    }

    private List<SqlInvokedFunction> getLatestFunctions() {
        String newETag = this.restApis.getFunctionsETag();
        Optional<String> currentETag = this.cachedETag.get();
        if (newETag != null && currentETag.isPresent() && this.cachedETag.get().equals(newETag)) {
            return this.latestFunctions;
        }
        this.latestFunctions.clear();
        UdfFunctionSignatureMap udfFunctionSignatureMap = this.restApis.getAllFunctions();
        if (udfFunctionSignatureMap == null || udfFunctionSignatureMap.isEmpty()) {
            return ImmutableList.of();
        }
        List<SqlInvokedFunction> newFunctions = this.createSqlInvokedFunctions(udfFunctionSignatureMap);
        this.latestFunctions.addAll(newFunctions);
        if (newETag != null) {
            this.cachedETag.set(Optional.of(newETag));
        }
        return this.latestFunctions;
    }

    private List<SqlInvokedFunction> createSqlInvokedFunctions(UdfFunctionSignatureMap udfFunctionSignatureMap) {
        Map udfSignatureMap = udfFunctionSignatureMap.getUDFSignatureMap();
        return (List)udfSignatureMap.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(metaInfo -> this.createSqlInvokedFunction((String)entry.getKey(), (JsonBasedUdfFunctionMetadata)metaInfo))).collect(ImmutableList.toImmutableList());
    }

    private SqlInvokedFunction createSqlInvokedFunction(String functionName, JsonBasedUdfFunctionMetadata jsonBasedUdfFunctionMetaData) {
        QualifiedObjectName qualifiedFunctionName = QualifiedObjectName.valueOf((CatalogSchemaName)new CatalogSchemaName(this.getCatalogName(), jsonBasedUdfFunctionMetaData.getSchema()), (String)functionName);
        List parameterNameList = jsonBasedUdfFunctionMetaData.getParamNames();
        List parameterTypeList = jsonBasedUdfFunctionMetaData.getParamTypes();
        ImmutableList.Builder parameterBuilder = ImmutableList.builder();
        for (int i = 0; i < parameterNameList.size(); ++i) {
            parameterBuilder.add((Object)new Parameter((String)parameterNameList.get(i), (TypeSignature)parameterTypeList.get(i)));
        }
        FunctionVersion functionVersion = new FunctionVersion(jsonBasedUdfFunctionMetaData.getVersion());
        SqlFunctionId functionId = jsonBasedUdfFunctionMetaData.getFunctionId().orElse(null);
        functionId = new SqlFunctionId(new QualifiedObjectName(this.getCatalogName(), functionId.getFunctionName().getSchemaName(), functionId.getFunctionName().getObjectName()), functionId.getArgumentTypes());
        return new SqlInvokedFunction(qualifiedFunctionName, (List)parameterBuilder.build(), Collections.emptyList(), Collections.emptyList(), jsonBasedUdfFunctionMetaData.getOutputType(), jsonBasedUdfFunctionMetaData.getDocString(), jsonBasedUdfFunctionMetaData.getRoutineCharacteristics(), "", jsonBasedUdfFunctionMetaData.getVariableArity(), functionVersion, jsonBasedUdfFunctionMetaData.getFunctionKind(), functionId, jsonBasedUdfFunctionMetaData.getAggregateMetadata(), Optional.of(new RestFunctionHandle(functionId, functionVersion.toString(), new Signature(qualifiedFunctionName, jsonBasedUdfFunctionMetaData.getFunctionKind(), jsonBasedUdfFunctionMetaData.getOutputType(), jsonBasedUdfFunctionMetaData.getParamTypes()))));
    }

    protected Collection<SqlInvokedFunction> fetchFunctionsDirect(QualifiedObjectName functionName) {
        UdfFunctionSignatureMap udfFunctionSignatureMap = this.restApis.getFunctions(functionName.getSchemaName(), functionName.getObjectName());
        if (udfFunctionSignatureMap == null || udfFunctionSignatureMap.isEmpty()) {
            return ImmutableList.of();
        }
        List<SqlInvokedFunction> functions = this.createSqlInvokedFunctions(udfFunctionSignatureMap);
        return functions;
    }

    protected UserDefinedType fetchUserDefinedTypeDirect(QualifiedObjectName typeName) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "User Defined Type is not supported in RestBasedFunctionNamespaceManager");
    }

    protected Optional<SqlInvokedFunction> getSqlInvokedFunction(SqlFunctionHandle functionHandle) {
        Collection<SqlInvokedFunction> functions = this.fetchFunctionsDirect(functionHandle.getFunctionId().getFunctionName());
        return functions.stream().filter(sqlFunction -> sqlFunction.getFunctionId().equals((Object)functionHandle.getFunctionId()) && sqlFunction.getVersion().toString().equals(functionHandle.getVersion())).findFirst();
    }

    protected FunctionMetadata fetchFunctionMetadataDirect(SqlFunctionHandle functionHandle) {
        this.checkCatalog((FunctionHandle)functionHandle);
        Optional<SqlInvokedFunction> function = this.getSqlInvokedFunction(functionHandle);
        if (!function.isPresent()) {
            throw new InvalidFunctionHandleException((FunctionHandle)functionHandle);
        }
        return this.sqlInvokedFunctionToMetadata(function.get());
    }

    protected ScalarFunctionImplementation fetchFunctionImplementationDirect(SqlFunctionHandle functionHandle) {
        this.checkCatalog((FunctionHandle)functionHandle);
        Optional<SqlInvokedFunction> function = this.getSqlInvokedFunction(functionHandle);
        if (!function.isPresent()) {
            throw new InvalidFunctionHandleException((FunctionHandle)functionHandle);
        }
        return this.sqlInvokedFunctionToImplementation(function.get());
    }

    public void createFunction(SqlInvokedFunction function, boolean replace) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Create Function is not supported in RestBasedFunctionNamespaceManager");
    }

    public void alterFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, AlterRoutineCharacteristics alterRoutineCharacteristics) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Alter Function is not supported in RestBasedFunctionNamespaceManager");
    }

    public void dropFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, boolean exists) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Drop Function is not supported in RestBasedFunctionNamespaceManager");
    }

    public Collection<SqlInvokedFunction> listFunctions(Optional<String> likePattern, Optional<String> escape) {
        return this.getLatestFunctions();
    }

    public void addUserDefinedType(UserDefinedType userDefinedType) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Add User Defined Type is not supported in RestBasedFunctionNamespaceManager");
    }
}

