/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.geospatial;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class BingTile {
    public static final int MAX_ZOOM_LEVEL = 23;
    private final int x;
    private final int y;
    private final int zoomLevel;

    private BingTile(int x, int y, int zoomLevel) {
        Preconditions.checkArgument((zoomLevel <= 23 ? 1 : 0) != 0);
        this.x = x;
        this.y = y;
        this.zoomLevel = zoomLevel;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BingTile otherTile = (BingTile)other;
        return this.x == otherTile.x && this.y == otherTile.y && this.zoomLevel == otherTile.zoomLevel;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.zoomLevel);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.x).add("y", this.y).add("zoom_level", this.zoomLevel).toString();
    }

    @JsonCreator
    public static BingTile fromCoordinates(@JsonProperty(value="x") int x, @JsonProperty(value="y") int y, @JsonProperty(value="zoom") int zoomLevel) {
        return new BingTile(x, y, zoomLevel);
    }

    public static BingTile fromQuadKey(String quadKey) {
        int zoomLevel = quadKey.length();
        Preconditions.checkArgument((zoomLevel <= 23 ? 1 : 0) != 0);
        int tileX = 0;
        int tileY = 0;
        block6: for (int i = zoomLevel; i > 0; --i) {
            int mask = 1 << i - 1;
            switch (quadKey.charAt(zoomLevel - i)) {
                case '0': {
                    continue block6;
                }
                case '1': {
                    tileX |= mask;
                    continue block6;
                }
                case '2': {
                    tileY |= mask;
                    continue block6;
                }
                case '3': {
                    tileX |= mask;
                    tileY |= mask;
                    continue block6;
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid QuadKey digit sequence: " + quadKey);
                }
            }
        }
        return new BingTile(tileX, tileY, zoomLevel);
    }

    @JsonProperty
    public int getX() {
        return this.x;
    }

    @JsonProperty
    public int getY() {
        return this.y;
    }

    @JsonProperty(value="zoom")
    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public String toQuadKey() {
        char[] quadKey = new char[this.zoomLevel];
        for (int i = this.zoomLevel; i > 0; --i) {
            int digit = 48;
            int mask = 1 << i - 1;
            if ((this.x & mask) != 0) {
                digit = (char)(digit + 1);
            }
            if ((this.y & mask) != 0) {
                digit = (char)(digit + 2);
            }
            quadKey[this.zoomLevel - i] = digit;
        }
        return String.valueOf(quadKey);
    }

    public long encode() {
        return ((long)this.x << 28) + (long)(this.y << 5) + (long)this.zoomLevel;
    }

    public static BingTile decode(long tile) {
        int tileX = (int)(tile >> 28);
        int tileY = (int)(tile % 0x10000000L >> 5);
        int zoomLevel = (int)(tile % 32L);
        return new BingTile(tileX, tileY, zoomLevel);
    }
}

