/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.geospatial;

import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.AbstractLongType;

public final class BingTileOperators {
    private BingTileOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="BingTile") long left, @SqlType(value="BingTile") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="BingTile") long left, @SqlType(value="BingTile") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@SqlType(value="BingTile") long left, @IsNull boolean leftNull, @SqlType(value="BingTile") long right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        return BingTileOperators.notEqual(left, right);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="BingTile") long value) {
        return AbstractLongType.hash((long)value);
    }
}

