/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.CompressionCodec;
import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcConf;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.RecordReader;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.StripeInformation;
import com.facebook.hive.orc.lazy.LazyBinaryTreeReader;
import com.facebook.hive.orc.lazy.LazyBooleanTreeReader;
import com.facebook.hive.orc.lazy.LazyByteTreeReader;
import com.facebook.hive.orc.lazy.LazyDoubleTreeReader;
import com.facebook.hive.orc.lazy.LazyFloatTreeReader;
import com.facebook.hive.orc.lazy.LazyIntTreeReader;
import com.facebook.hive.orc.lazy.LazyListTreeReader;
import com.facebook.hive.orc.lazy.LazyLongTreeReader;
import com.facebook.hive.orc.lazy.LazyMapTreeReader;
import com.facebook.hive.orc.lazy.LazyShortTreeReader;
import com.facebook.hive.orc.lazy.LazyStringTreeReader;
import com.facebook.hive.orc.lazy.LazyStructTreeReader;
import com.facebook.hive.orc.lazy.LazyTimestampTreeReader;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import com.facebook.hive.orc.lazy.LazyUnionTreeReader;
import com.facebook.hive.orc.lazy.OrcLazyBinary;
import com.facebook.hive.orc.lazy.OrcLazyBoolean;
import com.facebook.hive.orc.lazy.OrcLazyByte;
import com.facebook.hive.orc.lazy.OrcLazyDouble;
import com.facebook.hive.orc.lazy.OrcLazyFloat;
import com.facebook.hive.orc.lazy.OrcLazyInt;
import com.facebook.hive.orc.lazy.OrcLazyList;
import com.facebook.hive.orc.lazy.OrcLazyLong;
import com.facebook.hive.orc.lazy.OrcLazyMap;
import com.facebook.hive.orc.lazy.OrcLazyObject;
import com.facebook.hive.orc.lazy.OrcLazyRow;
import com.facebook.hive.orc.lazy.OrcLazyShort;
import com.facebook.hive.orc.lazy.OrcLazyString;
import com.facebook.hive.orc.lazy.OrcLazyStruct;
import com.facebook.hive.orc.lazy.OrcLazyTimestamp;
import com.facebook.hive.orc.lazy.OrcLazyUnion;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.ReaderWriterProfiler;

class RecordReaderImpl
implements RecordReader {
    private final FSDataInputStream file;
    private final long firstRow;
    private final List<StripeInformation> stripes = new ArrayList<StripeInformation>();
    private OrcProto.StripeFooter stripeFooter;
    private final long totalRowCount;
    private final CompressionCodec codec;
    private final int bufferSize;
    private final boolean[] included;
    private final long rowIndexStride;
    private long rowInStripe = 0L;
    private int currentStripe = 0;
    private long rowBaseInStripe = 0L;
    private long rowCountInStripe = 0L;
    private final Map<StreamName, InStream> streams = new HashMap<StreamName, InStream>();
    private OrcLazyRow reader;
    private final OrcProto.RowIndex[] indexes;
    private final int readStrides;
    private final boolean readEagerlyFromHdfs;
    private final long readEagerlyFromHdfsBytes;

    RecordReaderImpl(Iterable<StripeInformation> stripes, FileSystem fileSystem, Path path, long offset, long length, List<OrcProto.Type> types, CompressionCodec codec, int bufferSize, boolean[] included, long strideRate, Configuration conf) throws IOException {
        this.file = fileSystem.open(path);
        this.codec = codec;
        this.bufferSize = bufferSize;
        this.included = included;
        this.readStrides = OrcConf.getIntVar(conf, OrcConf.ConfVars.HIVE_ORC_READ_COMPRESSION_STRIDES);
        this.readEagerlyFromHdfs = OrcConf.getBoolVar(conf, OrcConf.ConfVars.HIVE_ORC_EAGER_HDFS_READ);
        this.readEagerlyFromHdfsBytes = OrcConf.getLongVar(conf, OrcConf.ConfVars.HIVE_ORC_EAGER_HDFS_READ_BYTES);
        long rows = 0L;
        long skippedRows = 0L;
        for (StripeInformation stripe : stripes) {
            long stripeStart = stripe.getOffset();
            if (offset > stripeStart) {
                skippedRows += stripe.getNumberOfRows();
                continue;
            }
            if (stripeStart >= offset + length) continue;
            this.stripes.add(stripe);
            rows += stripe.getNumberOfRows();
        }
        this.firstRow = skippedRows;
        this.totalRowCount = rows;
        this.indexes = new OrcProto.RowIndex[types.size()];
        this.rowIndexStride = strideRate;
        this.reader = this.createLazyRow(types, included);
        if (this.stripes.size() > 0) {
            this.readStripe();
        }
    }

    OrcLazyRow createLazyRow(List<OrcProto.Type> types, boolean[] included) throws IOException {
        OrcProto.Type type = types.get(0);
        int structFieldCount = type.getFieldNamesCount();
        OrcLazyObject[] structFields = new OrcLazyObject[structFieldCount];
        for (int i = 0; i < structFieldCount; ++i) {
            int subtype = type.getSubtypes(i);
            if (included != null && !included[subtype]) continue;
            structFields[i] = this.createLazyObject(subtype, types, included);
        }
        return new OrcLazyRow(structFields, type.getFieldNamesList());
    }

    LazyTreeReader createLazyTreeReader(int columnId, List<OrcProto.Type> types, boolean[] included) throws IOException {
        OrcProto.Type type = types.get(columnId);
        switch (type.getKind()) {
            case BOOLEAN: {
                return new LazyBooleanTreeReader(columnId, this.rowIndexStride);
            }
            case BYTE: {
                return new LazyByteTreeReader(columnId, this.rowIndexStride);
            }
            case DOUBLE: {
                return new LazyDoubleTreeReader(columnId, this.rowIndexStride);
            }
            case FLOAT: {
                return new LazyFloatTreeReader(columnId, this.rowIndexStride);
            }
            case SHORT: {
                return new LazyShortTreeReader(columnId, this.rowIndexStride);
            }
            case LONG: {
                return new LazyLongTreeReader(columnId, this.rowIndexStride);
            }
            case INT: {
                return new LazyIntTreeReader(columnId, this.rowIndexStride);
            }
            case STRING: {
                return new LazyStringTreeReader(columnId, this.rowIndexStride);
            }
            case BINARY: {
                return new LazyBinaryTreeReader(columnId, this.rowIndexStride);
            }
            case TIMESTAMP: {
                return new LazyTimestampTreeReader(columnId, this.rowIndexStride);
            }
            case STRUCT: {
                int structFieldCount = type.getFieldNamesCount();
                LazyTreeReader[] structFields = new LazyTreeReader[structFieldCount];
                for (int i = 0; i < structFieldCount; ++i) {
                    int subtype = type.getSubtypes(i);
                    if (included != null && !included[subtype]) continue;
                    structFields[i] = this.createLazyTreeReader(subtype, types, included);
                }
                return new LazyStructTreeReader(columnId, this.rowIndexStride, structFields, type.getFieldNamesList());
            }
            case LIST: {
                LazyTreeReader elementReader = this.createLazyTreeReader(type.getSubtypes(0), types, included);
                return new LazyListTreeReader(columnId, this.rowIndexStride, elementReader);
            }
            case MAP: {
                LazyTreeReader keyReader = this.createLazyTreeReader(type.getSubtypes(0), types, included);
                LazyTreeReader valueReader = this.createLazyTreeReader(type.getSubtypes(1), types, included);
                return new LazyMapTreeReader(columnId, this.rowIndexStride, keyReader, valueReader);
            }
            case UNION: {
                int unionFieldCount = type.getSubtypesCount();
                LazyTreeReader[] unionFields = new LazyTreeReader[unionFieldCount];
                for (int i = 0; i < unionFieldCount; ++i) {
                    unionFields[i] = this.createLazyTreeReader(type.getSubtypes(i), types, included);
                }
                return new LazyUnionTreeReader(columnId, this.rowIndexStride, unionFields);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)type.getKind()));
    }

    OrcLazyObject createLazyObject(int columnId, List<OrcProto.Type> types, boolean[] included) throws IOException {
        OrcProto.Type type = types.get(columnId);
        switch (type.getKind()) {
            case BOOLEAN: {
                return new OrcLazyBoolean((LazyBooleanTreeReader)this.createLazyTreeReader(columnId, types, included));
            }
            case BYTE: {
                return new OrcLazyByte((LazyByteTreeReader)this.createLazyTreeReader(columnId, types, included));
            }
            case DOUBLE: {
                return new OrcLazyDouble((LazyDoubleTreeReader)this.createLazyTreeReader(columnId, types, included));
            }
            case FLOAT: {
                return new OrcLazyFloat((LazyFloatTreeReader)this.createLazyTreeReader(columnId, types, included));
            }
            case SHORT: {
                return new OrcLazyShort((LazyShortTreeReader)this.createLazyTreeReader(columnId, types, included));
            }
            case LONG: {
                return new OrcLazyLong((LazyLongTreeReader)this.createLazyTreeReader(columnId, types, included));
            }
            case INT: {
                return new OrcLazyInt((LazyIntTreeReader)this.createLazyTreeReader(columnId, types, included));
            }
            case STRING: {
                return new OrcLazyString((LazyStringTreeReader)this.createLazyTreeReader(columnId, types, included));
            }
            case BINARY: {
                return new OrcLazyBinary((LazyBinaryTreeReader)this.createLazyTreeReader(columnId, types, included));
            }
            case TIMESTAMP: {
                return new OrcLazyTimestamp((LazyTimestampTreeReader)this.createLazyTreeReader(columnId, types, included));
            }
            case STRUCT: {
                return new OrcLazyStruct((LazyStructTreeReader)this.createLazyTreeReader(columnId, types, included));
            }
            case LIST: {
                return new OrcLazyList((LazyListTreeReader)this.createLazyTreeReader(columnId, types, included));
            }
            case MAP: {
                return new OrcLazyMap((LazyMapTreeReader)this.createLazyTreeReader(columnId, types, included));
            }
            case UNION: {
                return new OrcLazyUnion((LazyUnionTreeReader)this.createLazyTreeReader(columnId, types, included));
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)type.getKind()));
    }

    OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
        long offset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength();
        int tailLength = (int)stripe.getFooterLength();
        return OrcProto.StripeFooter.parseFrom(InStream.create("footer", this.file, offset, tailLength, this.codec, this.bufferSize));
    }

    private void readEntireStripeEagerly(StripeInformation stripe, long offset) throws IOException {
        byte[] buffer = new byte[(int)stripe.getDataLength()];
        this.file.seek(offset + stripe.getIndexLength());
        this.file.readFully(buffer, 0, buffer.length);
        int sectionOffset = 0;
        for (OrcProto.Stream section : this.stripeFooter.getStreamsList()) {
            if (StreamName.getArea(section.getKind()) != StreamName.Area.DATA && StreamName.getArea(section.getKind()) != StreamName.Area.DICTIONARY) continue;
            int sectionLength = (int)section.getLength();
            StreamName name = new StreamName(section.getColumn(), section.getKind());
            ByteBuffer sectionBuffer = ByteBuffer.wrap(buffer, sectionOffset, sectionLength);
            this.streams.put(name, InStream.create(name.toString(), sectionBuffer, this.codec, this.bufferSize, section.getUseVInts()));
            sectionOffset += sectionLength;
        }
    }

    private void readEntireStripeLazily(StripeInformation stripe, long offset) throws IOException {
        int sectionOffset = 0;
        for (OrcProto.Stream section : this.stripeFooter.getStreamsList()) {
            if (StreamName.getArea(section.getKind()) != StreamName.Area.DATA && StreamName.getArea(section.getKind()) != StreamName.Area.DICTIONARY) continue;
            int sectionLength = (int)section.getLength();
            StreamName name = new StreamName(section.getColumn(), section.getKind());
            this.streams.put(name, InStream.create(name.toString(), this.file, offset + stripe.getIndexLength() + (long)sectionOffset, sectionLength, this.codec, this.bufferSize, section.getUseVInts(), this.readStrides));
            sectionOffset += sectionLength;
        }
    }

    private void readIncludedStreamsEagerly(StripeInformation stripe, List<OrcProto.Stream> streamList, long offset, int currentSection) throws IOException {
        long sectionOffset = stripe.getIndexLength();
        while (currentSection < streamList.size()) {
            int bytes = 0;
            int excluded = currentSection;
            while (excluded < streamList.size() && this.included[streamList.get(excluded).getColumn()]) {
                bytes = (int)((long)bytes + streamList.get(excluded++).getLength());
            }
            if (currentSection < excluded) {
                byte[] buffer = new byte[bytes];
                this.file.seek(offset + sectionOffset);
                this.file.readFully(buffer, 0, bytes);
                sectionOffset += (long)bytes;
                bytes = 0;
                while (currentSection < excluded) {
                    OrcProto.Stream section = streamList.get(currentSection);
                    StreamName name = new StreamName(section.getColumn(), section.getKind());
                    this.streams.put(name, InStream.create(name.toString(), ByteBuffer.wrap(buffer, bytes, (int)section.getLength()), this.codec, this.bufferSize, section.getUseVInts()));
                    ++currentSection;
                    bytes = (int)((long)bytes + section.getLength());
                }
            }
            while (currentSection < streamList.size() && !this.included[streamList.get(currentSection).getColumn()]) {
                sectionOffset += streamList.get(currentSection).getLength();
                ++currentSection;
            }
        }
    }

    private void readIncludedStreamsLazily(StripeInformation stripe, List<OrcProto.Stream> streamList, long offset, int currentSection) throws IOException {
        long sectionOffset = stripe.getIndexLength();
        while (currentSection < streamList.size()) {
            if (this.included[streamList.get(currentSection).getColumn()]) {
                OrcProto.Stream section = streamList.get(currentSection);
                StreamName name = new StreamName(section.getColumn(), section.getKind());
                this.streams.put(name, InStream.create(name.toString(), this.file, offset + sectionOffset, (int)section.getLength(), this.codec, this.bufferSize, section.getUseVInts(), this.readStrides));
            }
            sectionOffset += streamList.get(currentSection).getLength();
            ++currentSection;
        }
    }

    protected boolean shouldReadEagerly(StripeInformation stripe, int currentSection) {
        if (this.readEagerlyFromHdfsBytes <= 0L) {
            return this.readEagerlyFromHdfs;
        }
        long inputBytes = 0L;
        if (this.included == null) {
            inputBytes = stripe.getDataLength();
        } else {
            List<OrcProto.Stream> streamList = this.stripeFooter.getStreamsList();
            for (int i = currentSection; i < streamList.size(); ++i) {
                if (!this.included[streamList.get(i).getColumn()]) continue;
                inputBytes += streamList.get(i).getLength();
            }
        }
        return inputBytes <= this.readEagerlyFromHdfsBytes;
    }

    private void readStripe() throws IOException {
        int i;
        StripeInformation stripe = this.stripes.get(this.currentStripe);
        this.stripeFooter = this.readStripeFooter(stripe);
        long offset = stripe.getOffset();
        this.streams.clear();
        if (this.included == null) {
            if (this.shouldReadEagerly(stripe, 0)) {
                this.readEntireStripeEagerly(stripe, offset);
            } else {
                this.readEntireStripeLazily(stripe, offset);
            }
        } else {
            int currentSection;
            List<OrcProto.Stream> streamList = this.stripeFooter.getStreamsList();
            for (currentSection = 0; currentSection < streamList.size() && StreamName.getArea(streamList.get(currentSection).getKind()) != StreamName.Area.DATA && StreamName.getArea(streamList.get(currentSection).getKind()) != StreamName.Area.DICTIONARY; ++currentSection) {
            }
            if (this.shouldReadEagerly(stripe, currentSection)) {
                this.readIncludedStreamsEagerly(stripe, streamList, offset, currentSection);
            } else {
                this.readIncludedStreamsLazily(stripe, streamList, offset, currentSection);
            }
        }
        this.rowInStripe = 0L;
        this.rowCountInStripe = stripe.getNumberOfRows();
        this.rowBaseInStripe = 0L;
        for (i = 0; i < this.currentStripe; ++i) {
            this.rowBaseInStripe += this.stripes.get(i).getNumberOfRows();
        }
        this.readRowIndex();
        ReaderWriterProfiler.start((ReaderWriterProfiler.Counter)ReaderWriterProfiler.Counter.DESERIALIZATION_TIME);
        this.reader.startStripe(this.streams, this.stripeFooter.getColumnsList(), this.indexes, this.rowBaseInStripe);
        ReaderWriterProfiler.end((ReaderWriterProfiler.Counter)ReaderWriterProfiler.Counter.DESERIALIZATION_TIME);
        for (i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = null;
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.rowInStripe < this.rowCountInStripe || this.currentStripe < this.stripes.size() - 1;
    }

    @Override
    public Object next(Object previous) throws IOException {
        if (this.rowInStripe >= this.rowCountInStripe) {
            this.reader.close();
            ++this.currentStripe;
            this.readStripe();
        }
        ++this.rowInStripe;
        if (previous == null) {
            previous = this.reader;
        } else if (previous != this.reader) {
            ((OrcLazyRow)previous).reset(this.reader);
            this.reader = (OrcLazyRow)previous;
        }
        ((OrcLazyObject)previous).next();
        return previous;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
        this.reader.close();
    }

    @Override
    public long getRowNumber() {
        return this.rowInStripe + this.rowBaseInStripe + this.firstRow;
    }

    @Override
    public float getProgress() {
        return ((float)this.rowBaseInStripe + (float)this.rowInStripe) / (float)this.totalRowCount;
    }

    private int findStripe(long rowNumber) {
        if (rowNumber < 0L) {
            throw new IllegalArgumentException("Seek to a negative row number " + rowNumber);
        }
        if (rowNumber < this.firstRow) {
            throw new IllegalArgumentException("Seek before reader range " + rowNumber);
        }
        rowNumber -= this.firstRow;
        for (int i = 0; i < this.stripes.size(); ++i) {
            StripeInformation stripe = this.stripes.get(i);
            if (stripe.getNumberOfRows() > rowNumber) {
                return i;
            }
            rowNumber -= stripe.getNumberOfRows();
        }
        throw new IllegalArgumentException("Seek after the end of reader range");
    }

    private void readRowIndex() throws IOException {
        long offset = this.stripes.get(this.currentStripe).getOffset();
        for (OrcProto.Stream stream : this.stripeFooter.getStreamsList()) {
            if (stream.getKind() == OrcProto.Stream.Kind.ROW_INDEX) {
                int col = stream.getColumn();
                if ((this.included == null || this.included[col]) && this.indexes[col] == null) {
                    this.indexes[col] = OrcProto.RowIndex.parseFrom(InStream.create("index", this.file, offset, (int)stream.getLength(), this.codec, this.bufferSize, stream.getUseVInts(), this.readStrides));
                }
            }
            offset += stream.getLength();
        }
    }

    @Override
    public void seekToRow(long rowNumber) throws IOException {
        int rightStripe = this.findStripe(rowNumber);
        if (rightStripe != this.currentStripe) {
            this.currentStripe = rightStripe;
            this.readStripe();
        }
        this.reader.seekToRow(rowNumber);
    }

    @Override
    public OrcLazyRow getReader() {
        return this.reader;
    }
}

