/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.json;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.json.JsonMapKeyReader;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.ByteArrayStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.StreamSources;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SliceDirectJsonReader
implements JsonMapKeyReader {
    private final StreamDescriptor streamDescriptor;
    private final boolean writeBinary;
    @Nullable
    private BooleanStream presentStream;
    @Nullable
    private LongStream lengthStream;
    @Nullable
    private ByteArrayStream dataStream;
    @Nonnull
    private byte[] data = new byte[1024];

    public SliceDirectJsonReader(StreamDescriptor streamDescriptor, boolean writeBinary) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.writeBinary = writeBinary;
    }

    @Override
    public void readNextValueInto(JsonGenerator generator) throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            generator.writeNull();
            return;
        }
        int length = this.bufferNextValue();
        if (this.writeBinary) {
            generator.writeBinary(this.data, 0, length);
        } else {
            generator.writeUTF8String(this.data, 0, length);
        }
    }

    @Override
    public String nextValueAsMapKey() throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            return null;
        }
        int length = this.bufferNextValue();
        if (this.writeBinary) {
            return BaseEncoding.base64().encode(this.data, 0, length);
        }
        return new String(this.data, 0, length, StandardCharsets.UTF_8);
    }

    private int bufferNextValue() throws IOException {
        OrcCorruptionException.verifyFormat(this.lengthStream != null, "Value is not null but length stream is not present", new Object[0]);
        int length = Ints.checkedCast((long)this.lengthStream.next());
        if (this.data.length < length) {
            this.data = new byte[length];
        }
        if (length > 0) {
            OrcCorruptionException.verifyFormat(this.dataStream != null, "Length is not zero but data stream is not present", new Object[0]);
            this.dataStream.next(length, this.data);
        }
        return length;
    }

    @Override
    public void skip(int skipSize) throws IOException {
        if (this.presentStream != null) {
            skipSize = this.presentStream.countBitsSet(skipSize);
        }
        if (skipSize == 0) {
            return;
        }
        OrcCorruptionException.verifyFormat(this.lengthStream != null, "Value is not null but length stream is not present", new Object[0]);
        long dataSkipSize = this.lengthStream.sum(skipSize);
        if (dataSkipSize == 0L) {
            return;
        }
        OrcCorruptionException.verifyFormat(this.dataStream != null, "Length is not zero but data stream is not present", new Object[0]);
        this.dataStream.skip(Ints.checkedCast((long)dataSkipSize));
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class).openStream();
        this.lengthStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongStream.class).openStream();
        this.dataStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, ByteArrayStream.class).openStream();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

