/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.json;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.json.JsonMapKeyReader;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.TimestampStreamReader;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.StreamSources;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimestampJsonReader
implements JsonMapKeyReader {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS");
    private final StreamDescriptor streamDescriptor;
    private final boolean writeStackType;
    private final DateTimeFormatter timestampFormatter;
    private final long baseTimestampInSeconds;
    @Nullable
    private BooleanStream presentStream;
    @Nullable
    private LongStream secondsStream;
    @Nullable
    private LongStream nanosStream;

    public TimestampJsonReader(StreamDescriptor streamDescriptor, boolean writeStackType, DateTimeZone hiveStorageTimeZone, DateTimeZone sessionTimeZone) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.writeStackType = writeStackType;
        this.timestampFormatter = TIMESTAMP_FORMATTER.withZone(sessionTimeZone);
        this.baseTimestampInSeconds = new DateTime(2015, 1, 1, 0, 0, (DateTimeZone)Preconditions.checkNotNull((Object)hiveStorageTimeZone, (Object)"hiveStorageTimeZone is null")).getMillis() / 1000L;
    }

    @Override
    public void readNextValueInto(JsonGenerator generator) throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            generator.writeNull();
            return;
        }
        OrcCorruptionException.verifyFormat(this.secondsStream != null, "Value is not null but seconds stream is not present", new Object[0]);
        OrcCorruptionException.verifyFormat(this.nanosStream != null, "Value is not null but nanos stream is not present", new Object[0]);
        long timestamp = TimestampStreamReader.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.baseTimestampInSeconds);
        if (this.writeStackType) {
            generator.writeNumber(timestamp);
        } else {
            String formattedTimestamp = this.timestampFormatter.print(timestamp);
            generator.writeString(formattedTimestamp);
        }
    }

    @Override
    public String nextValueAsMapKey() throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            return null;
        }
        OrcCorruptionException.verifyFormat(this.secondsStream != null, "Value is not null but seconds stream is not present", new Object[0]);
        OrcCorruptionException.verifyFormat(this.nanosStream != null, "Value is not null but nanos stream is not present", new Object[0]);
        long timestamp = TimestampStreamReader.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.baseTimestampInSeconds);
        if (this.writeStackType) {
            return String.valueOf(timestamp);
        }
        return this.timestampFormatter.print(timestamp);
    }

    @Override
    public void skip(int skipSize) throws IOException {
        if (this.presentStream != null) {
            skipSize = this.presentStream.countBitsSet(skipSize);
        }
        if (skipSize == 0) {
            return;
        }
        OrcCorruptionException.verifyFormat(this.secondsStream != null, "Value is not null but seconds stream is not present", new Object[0]);
        OrcCorruptionException.verifyFormat(this.nanosStream != null, "Value is not null but nanos stream is not present", new Object[0]);
        this.secondsStream.skip(skipSize);
        this.nanosStream.skip(skipSize);
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class).openStream();
        this.secondsStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongStream.class).openStream();
        this.nanosStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.SECONDARY, LongStream.class).openStream();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

