/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.checkpoint.FloatStreamCheckpoint;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.OrcStreamUtils;
import com.facebook.presto.orc.stream.ValueStream;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;

public class FloatStream
implements ValueStream<FloatStreamCheckpoint> {
    private final OrcInputStream input;
    private final byte[] buffer = new byte[4096];
    private final Slice slice = Slices.wrappedBuffer((byte[])this.buffer);

    public FloatStream(OrcInputStream input) {
        this.input = input;
    }

    @Override
    public Class<FloatStreamCheckpoint> getCheckpointType() {
        return FloatStreamCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(FloatStreamCheckpoint checkpoint) throws IOException {
        this.input.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
    }

    @Override
    public void skip(int items) throws IOException {
        long length = items * 4;
        OrcStreamUtils.skipFully(this.input, length);
    }

    public float next() throws IOException {
        OrcStreamUtils.readFully(this.input, this.buffer, 0, 4);
        return this.slice.getFloat(0);
    }

    public void nextVector(int items, double[] vector) throws IOException {
        Preconditions.checkPositionIndex((int)items, (int)vector.length);
        Preconditions.checkPositionIndex((int)items, (int)1024);
        OrcStreamUtils.readFully(this.input, this.buffer, 0, items * 4);
        int elementIndex = 0;
        for (int i = 0; i < items; ++i) {
            vector[i] = this.slice.getFloat(elementIndex);
            elementIndex += 4;
        }
    }

    public void nextVector(long items, double[] vector, boolean[] isNull) throws IOException {
        int notNullCount = 0;
        int i = 0;
        while ((long)i < items) {
            if (!isNull[i]) {
                ++notNullCount;
            }
            ++i;
        }
        OrcStreamUtils.readFully(this.input, this.buffer, 0, notNullCount * 4);
        int elementIndex = 0;
        int i2 = 0;
        while ((long)i2 < items) {
            if (!isNull[i2]) {
                vector[i2] = this.slice.getFloat(elementIndex);
                elementIndex += 4;
            }
            ++i2;
        }
    }
}

