/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudfront.AmazonCloudFrontAsync;
import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResult;
import com.amazonaws.services.cloudfront.model.CreateDistributionRequest;
import com.amazonaws.services.cloudfront.model.CreateDistributionResult;
import com.amazonaws.services.cloudfront.model.CreateInvalidationRequest;
import com.amazonaws.services.cloudfront.model.CreateInvalidationResult;
import com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.CreateStreamingDistributionResult;
import com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.DeleteDistributionRequest;
import com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResult;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResult;
import com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest;
import com.amazonaws.services.cloudfront.model.GetDistributionConfigResult;
import com.amazonaws.services.cloudfront.model.GetDistributionRequest;
import com.amazonaws.services.cloudfront.model.GetDistributionResult;
import com.amazonaws.services.cloudfront.model.GetInvalidationRequest;
import com.amazonaws.services.cloudfront.model.GetInvalidationResult;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigResult;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionResult;
import com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResult;
import com.amazonaws.services.cloudfront.model.ListDistributionsRequest;
import com.amazonaws.services.cloudfront.model.ListDistributionsResult;
import com.amazonaws.services.cloudfront.model.ListInvalidationsRequest;
import com.amazonaws.services.cloudfront.model.ListInvalidationsResult;
import com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest;
import com.amazonaws.services.cloudfront.model.ListStreamingDistributionsResult;
import com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResult;
import com.amazonaws.services.cloudfront.model.UpdateDistributionRequest;
import com.amazonaws.services.cloudfront.model.UpdateDistributionResult;
import com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonCloudFrontAsyncClient
extends AmazonCloudFrontClient
implements AmazonCloudFrontAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonCloudFrontAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCloudFrontAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudFrontAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudFrontAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonCloudFrontAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCloudFrontAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudFrontAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonCloudFrontAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudFrontAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<Void> deleteStreamingDistributionAsync(final DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonCloudFrontAsyncClient.this.deleteStreamingDistribution(deleteStreamingDistributionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteStreamingDistributionAsync(final DeleteStreamingDistributionRequest deleteStreamingDistributionRequest, final AsyncHandler<DeleteStreamingDistributionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonCloudFrontAsyncClient.this.deleteStreamingDistribution(deleteStreamingDistributionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteStreamingDistributionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<GetStreamingDistributionResult> getStreamingDistributionAsync(final GetStreamingDistributionRequest getStreamingDistributionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetStreamingDistributionResult>(){

            @Override
            public GetStreamingDistributionResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.getStreamingDistribution(getStreamingDistributionRequest);
            }
        });
    }

    @Override
    public Future<GetStreamingDistributionResult> getStreamingDistributionAsync(final GetStreamingDistributionRequest getStreamingDistributionRequest, final AsyncHandler<GetStreamingDistributionRequest, GetStreamingDistributionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetStreamingDistributionResult>(){

            @Override
            public GetStreamingDistributionResult call() throws Exception {
                GetStreamingDistributionResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.getStreamingDistribution(getStreamingDistributionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getStreamingDistributionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListDistributionsResult> listDistributionsAsync(final ListDistributionsRequest listDistributionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDistributionsResult>(){

            @Override
            public ListDistributionsResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.listDistributions(listDistributionsRequest);
            }
        });
    }

    @Override
    public Future<ListDistributionsResult> listDistributionsAsync(final ListDistributionsRequest listDistributionsRequest, final AsyncHandler<ListDistributionsRequest, ListDistributionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDistributionsResult>(){

            @Override
            public ListDistributionsResult call() throws Exception {
                ListDistributionsResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.listDistributions(listDistributionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listDistributionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteCloudFrontOriginAccessIdentityAsync(final DeleteCloudFrontOriginAccessIdentityRequest deleteCloudFrontOriginAccessIdentityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonCloudFrontAsyncClient.this.deleteCloudFrontOriginAccessIdentity(deleteCloudFrontOriginAccessIdentityRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteCloudFrontOriginAccessIdentityAsync(final DeleteCloudFrontOriginAccessIdentityRequest deleteCloudFrontOriginAccessIdentityRequest, final AsyncHandler<DeleteCloudFrontOriginAccessIdentityRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonCloudFrontAsyncClient.this.deleteCloudFrontOriginAccessIdentity(deleteCloudFrontOriginAccessIdentityRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteCloudFrontOriginAccessIdentityRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<GetInvalidationResult> getInvalidationAsync(final GetInvalidationRequest getInvalidationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetInvalidationResult>(){

            @Override
            public GetInvalidationResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.getInvalidation(getInvalidationRequest);
            }
        });
    }

    @Override
    public Future<GetInvalidationResult> getInvalidationAsync(final GetInvalidationRequest getInvalidationRequest, final AsyncHandler<GetInvalidationRequest, GetInvalidationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetInvalidationResult>(){

            @Override
            public GetInvalidationResult call() throws Exception {
                GetInvalidationResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.getInvalidation(getInvalidationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getInvalidationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateStreamingDistributionResult> updateStreamingDistributionAsync(final UpdateStreamingDistributionRequest updateStreamingDistributionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateStreamingDistributionResult>(){

            @Override
            public UpdateStreamingDistributionResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.updateStreamingDistribution(updateStreamingDistributionRequest);
            }
        });
    }

    @Override
    public Future<UpdateStreamingDistributionResult> updateStreamingDistributionAsync(final UpdateStreamingDistributionRequest updateStreamingDistributionRequest, final AsyncHandler<UpdateStreamingDistributionRequest, UpdateStreamingDistributionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateStreamingDistributionResult>(){

            @Override
            public UpdateStreamingDistributionResult call() throws Exception {
                UpdateStreamingDistributionResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.updateStreamingDistribution(updateStreamingDistributionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateStreamingDistributionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetDistributionResult> getDistributionAsync(final GetDistributionRequest getDistributionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetDistributionResult>(){

            @Override
            public GetDistributionResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.getDistribution(getDistributionRequest);
            }
        });
    }

    @Override
    public Future<GetDistributionResult> getDistributionAsync(final GetDistributionRequest getDistributionRequest, final AsyncHandler<GetDistributionRequest, GetDistributionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetDistributionResult>(){

            @Override
            public GetDistributionResult call() throws Exception {
                GetDistributionResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.getDistribution(getDistributionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getDistributionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetStreamingDistributionConfigResult> getStreamingDistributionConfigAsync(final GetStreamingDistributionConfigRequest getStreamingDistributionConfigRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetStreamingDistributionConfigResult>(){

            @Override
            public GetStreamingDistributionConfigResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.getStreamingDistributionConfig(getStreamingDistributionConfigRequest);
            }
        });
    }

    @Override
    public Future<GetStreamingDistributionConfigResult> getStreamingDistributionConfigAsync(final GetStreamingDistributionConfigRequest getStreamingDistributionConfigRequest, final AsyncHandler<GetStreamingDistributionConfigRequest, GetStreamingDistributionConfigResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetStreamingDistributionConfigResult>(){

            @Override
            public GetStreamingDistributionConfigResult call() throws Exception {
                GetStreamingDistributionConfigResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.getStreamingDistributionConfig(getStreamingDistributionConfigRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getStreamingDistributionConfigRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCloudFrontOriginAccessIdentityResult> updateCloudFrontOriginAccessIdentityAsync(final UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateCloudFrontOriginAccessIdentityResult>(){

            @Override
            public UpdateCloudFrontOriginAccessIdentityResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.updateCloudFrontOriginAccessIdentity(updateCloudFrontOriginAccessIdentityRequest);
            }
        });
    }

    @Override
    public Future<UpdateCloudFrontOriginAccessIdentityResult> updateCloudFrontOriginAccessIdentityAsync(final UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest, final AsyncHandler<UpdateCloudFrontOriginAccessIdentityRequest, UpdateCloudFrontOriginAccessIdentityResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateCloudFrontOriginAccessIdentityResult>(){

            @Override
            public UpdateCloudFrontOriginAccessIdentityResult call() throws Exception {
                UpdateCloudFrontOriginAccessIdentityResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.updateCloudFrontOriginAccessIdentity(updateCloudFrontOriginAccessIdentityRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateCloudFrontOriginAccessIdentityRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateCloudFrontOriginAccessIdentityResult> createCloudFrontOriginAccessIdentityAsync(final CreateCloudFrontOriginAccessIdentityRequest createCloudFrontOriginAccessIdentityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateCloudFrontOriginAccessIdentityResult>(){

            @Override
            public CreateCloudFrontOriginAccessIdentityResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.createCloudFrontOriginAccessIdentity(createCloudFrontOriginAccessIdentityRequest);
            }
        });
    }

    @Override
    public Future<CreateCloudFrontOriginAccessIdentityResult> createCloudFrontOriginAccessIdentityAsync(final CreateCloudFrontOriginAccessIdentityRequest createCloudFrontOriginAccessIdentityRequest, final AsyncHandler<CreateCloudFrontOriginAccessIdentityRequest, CreateCloudFrontOriginAccessIdentityResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateCloudFrontOriginAccessIdentityResult>(){

            @Override
            public CreateCloudFrontOriginAccessIdentityResult call() throws Exception {
                CreateCloudFrontOriginAccessIdentityResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.createCloudFrontOriginAccessIdentity(createCloudFrontOriginAccessIdentityRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createCloudFrontOriginAccessIdentityRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListCloudFrontOriginAccessIdentitiesResult> listCloudFrontOriginAccessIdentitiesAsync(final ListCloudFrontOriginAccessIdentitiesRequest listCloudFrontOriginAccessIdentitiesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListCloudFrontOriginAccessIdentitiesResult>(){

            @Override
            public ListCloudFrontOriginAccessIdentitiesResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.listCloudFrontOriginAccessIdentities(listCloudFrontOriginAccessIdentitiesRequest);
            }
        });
    }

    @Override
    public Future<ListCloudFrontOriginAccessIdentitiesResult> listCloudFrontOriginAccessIdentitiesAsync(final ListCloudFrontOriginAccessIdentitiesRequest listCloudFrontOriginAccessIdentitiesRequest, final AsyncHandler<ListCloudFrontOriginAccessIdentitiesRequest, ListCloudFrontOriginAccessIdentitiesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListCloudFrontOriginAccessIdentitiesResult>(){

            @Override
            public ListCloudFrontOriginAccessIdentitiesResult call() throws Exception {
                ListCloudFrontOriginAccessIdentitiesResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.listCloudFrontOriginAccessIdentities(listCloudFrontOriginAccessIdentitiesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listCloudFrontOriginAccessIdentitiesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListStreamingDistributionsResult> listStreamingDistributionsAsync(final ListStreamingDistributionsRequest listStreamingDistributionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListStreamingDistributionsResult>(){

            @Override
            public ListStreamingDistributionsResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.listStreamingDistributions(listStreamingDistributionsRequest);
            }
        });
    }

    @Override
    public Future<ListStreamingDistributionsResult> listStreamingDistributionsAsync(final ListStreamingDistributionsRequest listStreamingDistributionsRequest, final AsyncHandler<ListStreamingDistributionsRequest, ListStreamingDistributionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListStreamingDistributionsResult>(){

            @Override
            public ListStreamingDistributionsResult call() throws Exception {
                ListStreamingDistributionsResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.listStreamingDistributions(listStreamingDistributionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listStreamingDistributionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetDistributionConfigResult> getDistributionConfigAsync(final GetDistributionConfigRequest getDistributionConfigRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetDistributionConfigResult>(){

            @Override
            public GetDistributionConfigResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.getDistributionConfig(getDistributionConfigRequest);
            }
        });
    }

    @Override
    public Future<GetDistributionConfigResult> getDistributionConfigAsync(final GetDistributionConfigRequest getDistributionConfigRequest, final AsyncHandler<GetDistributionConfigRequest, GetDistributionConfigResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetDistributionConfigResult>(){

            @Override
            public GetDistributionConfigResult call() throws Exception {
                GetDistributionConfigResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.getDistributionConfig(getDistributionConfigRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getDistributionConfigRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteDistributionAsync(final DeleteDistributionRequest deleteDistributionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonCloudFrontAsyncClient.this.deleteDistribution(deleteDistributionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDistributionAsync(final DeleteDistributionRequest deleteDistributionRequest, final AsyncHandler<DeleteDistributionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonCloudFrontAsyncClient.this.deleteDistribution(deleteDistributionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteDistributionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateInvalidationResult> createInvalidationAsync(final CreateInvalidationRequest createInvalidationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateInvalidationResult>(){

            @Override
            public CreateInvalidationResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.createInvalidation(createInvalidationRequest);
            }
        });
    }

    @Override
    public Future<CreateInvalidationResult> createInvalidationAsync(final CreateInvalidationRequest createInvalidationRequest, final AsyncHandler<CreateInvalidationRequest, CreateInvalidationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateInvalidationResult>(){

            @Override
            public CreateInvalidationResult call() throws Exception {
                CreateInvalidationResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.createInvalidation(createInvalidationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createInvalidationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetCloudFrontOriginAccessIdentityResult> getCloudFrontOriginAccessIdentityAsync(final GetCloudFrontOriginAccessIdentityRequest getCloudFrontOriginAccessIdentityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetCloudFrontOriginAccessIdentityResult>(){

            @Override
            public GetCloudFrontOriginAccessIdentityResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.getCloudFrontOriginAccessIdentity(getCloudFrontOriginAccessIdentityRequest);
            }
        });
    }

    @Override
    public Future<GetCloudFrontOriginAccessIdentityResult> getCloudFrontOriginAccessIdentityAsync(final GetCloudFrontOriginAccessIdentityRequest getCloudFrontOriginAccessIdentityRequest, final AsyncHandler<GetCloudFrontOriginAccessIdentityRequest, GetCloudFrontOriginAccessIdentityResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetCloudFrontOriginAccessIdentityResult>(){

            @Override
            public GetCloudFrontOriginAccessIdentityResult call() throws Exception {
                GetCloudFrontOriginAccessIdentityResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.getCloudFrontOriginAccessIdentity(getCloudFrontOriginAccessIdentityRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getCloudFrontOriginAccessIdentityRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateStreamingDistributionResult> createStreamingDistributionAsync(final CreateStreamingDistributionRequest createStreamingDistributionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateStreamingDistributionResult>(){

            @Override
            public CreateStreamingDistributionResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.createStreamingDistribution(createStreamingDistributionRequest);
            }
        });
    }

    @Override
    public Future<CreateStreamingDistributionResult> createStreamingDistributionAsync(final CreateStreamingDistributionRequest createStreamingDistributionRequest, final AsyncHandler<CreateStreamingDistributionRequest, CreateStreamingDistributionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateStreamingDistributionResult>(){

            @Override
            public CreateStreamingDistributionResult call() throws Exception {
                CreateStreamingDistributionResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.createStreamingDistribution(createStreamingDistributionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createStreamingDistributionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetCloudFrontOriginAccessIdentityConfigResult> getCloudFrontOriginAccessIdentityConfigAsync(final GetCloudFrontOriginAccessIdentityConfigRequest getCloudFrontOriginAccessIdentityConfigRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetCloudFrontOriginAccessIdentityConfigResult>(){

            @Override
            public GetCloudFrontOriginAccessIdentityConfigResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.getCloudFrontOriginAccessIdentityConfig(getCloudFrontOriginAccessIdentityConfigRequest);
            }
        });
    }

    @Override
    public Future<GetCloudFrontOriginAccessIdentityConfigResult> getCloudFrontOriginAccessIdentityConfigAsync(final GetCloudFrontOriginAccessIdentityConfigRequest getCloudFrontOriginAccessIdentityConfigRequest, final AsyncHandler<GetCloudFrontOriginAccessIdentityConfigRequest, GetCloudFrontOriginAccessIdentityConfigResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetCloudFrontOriginAccessIdentityConfigResult>(){

            @Override
            public GetCloudFrontOriginAccessIdentityConfigResult call() throws Exception {
                GetCloudFrontOriginAccessIdentityConfigResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.getCloudFrontOriginAccessIdentityConfig(getCloudFrontOriginAccessIdentityConfigRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getCloudFrontOriginAccessIdentityConfigRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDistributionResult> updateDistributionAsync(final UpdateDistributionRequest updateDistributionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateDistributionResult>(){

            @Override
            public UpdateDistributionResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.updateDistribution(updateDistributionRequest);
            }
        });
    }

    @Override
    public Future<UpdateDistributionResult> updateDistributionAsync(final UpdateDistributionRequest updateDistributionRequest, final AsyncHandler<UpdateDistributionRequest, UpdateDistributionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateDistributionResult>(){

            @Override
            public UpdateDistributionResult call() throws Exception {
                UpdateDistributionResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.updateDistribution(updateDistributionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateDistributionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateDistributionResult> createDistributionAsync(final CreateDistributionRequest createDistributionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDistributionResult>(){

            @Override
            public CreateDistributionResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.createDistribution(createDistributionRequest);
            }
        });
    }

    @Override
    public Future<CreateDistributionResult> createDistributionAsync(final CreateDistributionRequest createDistributionRequest, final AsyncHandler<CreateDistributionRequest, CreateDistributionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDistributionResult>(){

            @Override
            public CreateDistributionResult call() throws Exception {
                CreateDistributionResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.createDistribution(createDistributionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createDistributionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListInvalidationsResult> listInvalidationsAsync(final ListInvalidationsRequest listInvalidationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListInvalidationsResult>(){

            @Override
            public ListInvalidationsResult call() throws Exception {
                return AmazonCloudFrontAsyncClient.this.listInvalidations(listInvalidationsRequest);
            }
        });
    }

    @Override
    public Future<ListInvalidationsResult> listInvalidationsAsync(final ListInvalidationsRequest listInvalidationsRequest, final AsyncHandler<ListInvalidationsRequest, ListInvalidationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListInvalidationsResult>(){

            @Override
            public ListInvalidationsResult call() throws Exception {
                ListInvalidationsResult result;
                try {
                    result = AmazonCloudFrontAsyncClient.this.listInvalidations(listInvalidationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listInvalidationsRequest, result);
                return result;
            }
        });
    }
}

