/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Multimap;
import java.lang.reflect.Type;

public class GuavaTypeModifier
extends TypeModifier {
    public JavaType modifyType(JavaType type, Type jdkType, TypeBindings context, TypeFactory typeFactory) {
        Class raw = type.getRawClass();
        if (Multimap.class.isAssignableFrom(raw)) {
            JavaType keyType = type.containedType(0);
            JavaType contentType = type.containedType(1);
            if (keyType == null) {
                keyType = TypeFactory.unknownType();
            }
            if (contentType == null) {
                contentType = TypeFactory.unknownType();
            }
            return typeFactory.constructMapLikeType(type.getRawClass(), keyType, contentType);
        }
        if (FluentIterable.class.isAssignableFrom(raw)) {
            JavaType elemType;
            block8: {
                elemType = null;
                try {
                    JavaType[] types = typeFactory.findTypeParameters(type, Iterable.class);
                    if (types != null && types.length > 0) {
                        elemType = types[0];
                    }
                }
                catch (IllegalArgumentException e) {
                    String msg = e.getMessage();
                    if (msg != null && msg.contains("Type variable 'T' can not be resolved")) break block8;
                    throw e;
                }
            }
            if (elemType == null) {
                elemType = TypeFactory.unknownType();
            }
            return typeFactory.constructParametricType(Iterable.class, new JavaType[]{elemType});
        }
        return type;
    }
}

