/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.collect.Range;
import java.io.IOException;

public class RangeSerializer
extends StdSerializer<Range<?>>
implements ContextualSerializer {
    protected final JavaType _rangeType;
    protected final JsonSerializer<Object> _endpointSerializer;

    public RangeSerializer(JavaType type) {
        this(type, null);
    }

    public RangeSerializer(JavaType type, JsonSerializer<?> endpointSer) {
        super(type);
        this._rangeType = type;
        this._endpointSerializer = endpointSer;
    }

    public boolean isEmpty(Range<?> value) {
        return super.isEmpty(value);
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JavaType endpointType;
        if (this._endpointSerializer == null && (endpointType = this._rangeType.containedType(0)) != null && !endpointType.hasRawClass(Object.class)) {
            JsonSerializer ser = prov.findValueSerializer(endpointType, property);
            return new RangeSerializer(this._rangeType, ser);
        }
        return this;
    }

    public void serialize(Range<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        this._writeContents(value, jgen, provider);
        jgen.writeEndObject();
    }

    public void serializeWithType(Range<?> value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForObject(value, jgen);
        this._writeContents(value, jgen, provider);
        typeSer.writeTypeSuffixForObject(value, jgen);
    }

    private void _writeContents(Range<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value.hasLowerBound()) {
            if (this._endpointSerializer != null) {
                jgen.writeFieldName("lowerEndpoint");
                this._endpointSerializer.serialize((Object)value.lowerEndpoint(), jgen, provider);
            } else {
                provider.defaultSerializeField("lowerEndpoint", (Object)value.lowerEndpoint(), jgen);
            }
            provider.defaultSerializeField("lowerBoundType", (Object)value.lowerBoundType(), jgen);
        }
        if (value.hasUpperBound()) {
            if (this._endpointSerializer != null) {
                jgen.writeFieldName("upperEndpoint");
                this._endpointSerializer.serialize((Object)value.upperEndpoint(), jgen, provider);
            } else {
                provider.defaultSerializeField("upperEndpoint", (Object)value.upperEndpoint(), jgen);
            }
            provider.defaultSerializeField("upperBoundType", (Object)value.upperBoundType(), jgen);
        }
    }
}

